; The use and distribution of the information
; contained herein may be restricted.
;
.iif	ndf	$list$	.nlist
.title	common	common definitions
.nlist	ttm
.list	toc,meb,bex
; .dsabl	reg,gbl	; deleted for 'macro'
sysvel	=	"05		;major major
sysvee	=	'b		;minor level

; general registers defined

r0	=	%0
r1	=	%1
r2	=	%2
r3	=	%3
r4	=	%4
r5	=	%5
sp	=	%6
pc	=	%7
.macro	title	seg,name,num,dat,who
.list
.title	seg	name
.endm

.macro	ident	num
.if	eq	sysvee
.list
.ident	<sysvel&177-22><sysvel/400&177-22>".'num'"
.nlist
.iff
.list
.ident	<sysvel&177-22><sysvel/400&177-22><sysvee&177-100>".'num'"
.nlist
.endc
.endm


.macro	org	sec,off
.macro	unorg
.list	bex
.csect	sec
.endm
	tmporg	sec,off
.endm

.macro	tmporg	sec,off
.list	bex
.csect	sec
.if	ndf	sec
sec:
.endc
.if	nb	<off>
.	=	off+sec
.endc
.endm
.macro	entry	tag
.globl	tag
tag:
.endm

.macro	global	sym
.irp	tag,<sym>
.globl	tag
.endm
.endm

.macro	zskip	n,qn
.irp	tmptag,<\n>
.list
; fill for tmptag'(base 8) words comes here...
.nlist
.endm
.nlist
.rept	n
	.word	qn+0
.endr
.list
.endm

.macro	$.equ.	tag,value
.iif	ndf	tag	tag=value
.if	ne	value-tag
.error	; tag is not correctly defined
.endc
.list
				tag	=	tag
.nlist
.endm

.macro	$.def.	tag,size
.iif	ndf	tag	tag=tmptag
.if	ne	tmptag-tag
.error	; tag is not correctly defined
.endc
.list
				tag	=	tag
.nlist
tmptag	=	size+tmptag
.iif lt size	.error		;bad .def.
.endm
; common machine definitions

; processor status bit assignments

$.equ.	c	,	 1	;carry flag
$.equ.	v	,	 2	;overflow indicator
$.equ.	z	,	 4	;zero flag
$.equ.	n	,	10	;negative flag
$.equ.	t	,	20	;t-bit instruction trap

; transfer control block (xrb)

; used by user to initiate an i/o request
;and for monitor/user data requests

$.equ.	xrlen	,	 0	;length of i/o buffer in bytes
$.equ.	xrbc	,	 2	;byte count of transfer
$.equ.	xrloc	,	 4	;pointer to buffer start for transfer
$.equ.	xrci	,	 6	;channel number for transfer
$.equ.	xrblk	,	10	;starting device block number for transfer
$.equ.	xrtime	,	12	;wait time for tty input
$.equ.	xrxxx	,	14	;to report porblem name

$.equ.	xrbsiz	,	22	;reserve 9 words for xrb

; values in 'xrlen' and 'xrloc' and 'xrci' must be even!

; value in 'xrlen' must be >= the default value

; value in 'xrbc' must be <= value in 'xrlen'
; file request queue block (firqb)  (pronounced 'furk-be')

; all requests for file processing are made by setting the necessary parameters
;in the firqb, and calling the monitor with "calfip".

; only relevant parameters need be supplied. when fip exits, the
;returned values come back in the firqb along with an error code.

; firqb entries include the following:

$.equ.	fqjob	, 2		;2*job # issuing request
$.equ.	fqfun	, 3		;function requested
$.equ.	fqfil	, 4		;2*channel number
$.equ.	fqerno	, 4		;error message code and text begin
$.equ.	fqnam1	, 6		;first path name
$.equ.	fqnam2	,106		;second path name
$.equ.	fqbufl	,206		;buffer length
$.equ.	fqmode	,210		;UNIX mode
$.equ.	fqbits	,212		;BASIC mode
$.equ.	fqflag	,214		;some flags
$.equ.	fqsiz	,216		;length in blocks (for run)
$.equ.	fqnent	,220		;line number for run
$.equ.	fqlksz	,222		;block size for device

$.equ.	fqbsiz	,224		;72. words for furk-bee
; The running job's special data area
	org	ucore
tmptag	=	.		;starting here...

$.def.	usrorg	,000		;origin of user's image
$.def.	key	,2		;keyword of job's current status
$.def.	firqb	,fqbsiz		;file request block
$.def.	xrb	,xrbsiz		;transfer control block

$.equ.	jobf	,key		;keyword area
$.equ.	iosts	,firqb		;word of i/o status for errors
$.equ.	job	,firqb+fqjob	;byte of running job number times 2
$.equ.	jfonce	,040000		;mon knows about this

; firqb function definitions.

; this list contains the firqb function codes to be loaded into
;the "fqfun" field of a firqb used in a fip call. a macro is used to
;define these items to allow addition without regard to order and
;define the list's length automatically.
; the function code then is used to define the function's position
;in a table used by fip to do the calling.

; the macro to define a firqb function:

.macro	$fqdef	fun
.iif	ndf	fun'fq	fun'fq=fipsiz
.if	ne	fun'fq-fipsiz
.error	; fun'fq is incorrectly defined
.endc
fipsiz	=	fipsiz+2
.list
		fun'fq	=	fun'fq
.nlist
.endm

fipsiz	=	0	;functions start at 0
; run-time system issueing functions

$fqdef	cls	;close an open channel
$fqdef	opn	;open a channel
$fqdef	cre	;create/extend/open a channel
$fqdef	dln	;delete a file by name
$fqdef	ren	;rename a file
$fqdef	err	;get error message text
$fqdef	rst	;reset (close) [all] channel[s except 0]
$fqdef	lok	;lookup a file
$fqdef	crt	;create/extend/open a unique .tmp file on disk
$fqdef	crb	;create/extend/open a compiled image file on disk

.macro	$emdef	name,rtn
	.globl	rtn
	.globl	unxent
	.macro	name
		jsr	r5,unxent
		.word	rtn
	.endm
.endm

.macro	$erdef	name
	.if	nb	<name>
	.iif	ndf	name,	name=emt+tmptag
	.iif	ne	name-emt-tmptag,	.error
	.endc
	tmptag=tmptag+1
.endm

	$.equ.	fatal,	200

	tmptag	=	1

; errors defined...


$erdef			;Bad directory for device
$erdef	badnam		;badly formed file name
$erdef	inuse		;file of same name is in use
$erdef	noroom		;directory is full or sat is empty
$erdef	nosuch		;file or ufd does not exist
$erdef	nodevc		;no such device on the system
$erdef	notcls		;can't open already open channel
$erdef			;device not available
$erdef	notopn		;trying to operate on uninitted channel
$erdef	prviol		;protection violation
$erdef	eof		;end of file on read/write
$erdef	abort		;operation aborted
$erdef	daterr		;data error on device
$erdef			;device hung
$erdef	hngtty		;hung tty for job (wait exhausted)
$erdef	fiexst		;file already exists--delete it first
$erdef			;too many open files
$erdef	badfuo		;illegal fip uuo for job
$erdef			;disk block is interlocked
$erdef			;pack id's don't match
$erdef			;disk pack is not mounted
$erdef			;disk pack is locked out
$erdef	badclu		;bad cluster size specified
$erdef			;disk pack is private
$erdef	nofork		;unable to fork
$erdef	prgerr		;program returned error
$erdef			;i/o to detached keyboard
$erdef	ctrlce		;^c program abort
$erdef			;corrupted file structure
$erdef			;device not file structured
$erdef	badcnt		;bad byte count specified in .write
$erdef			;no room for FCB
$erdef			;UNIBUS timeout
$erdef			;reserved instruction trap
$erdef			;memory management trap
$erdef			;stack (r6) overflow
$erdef			;disk error during swap
$erdef			;memory parity error
$erdef			;magtape select error
$erdef			;magtape record length error
$erdef			;non-resident run-time system
$erdef	vcserr		;virtual buffer not 512. bytes
$erdef	vcaerr		;virtual core not on disk
$erdef	sizerr		;array too big
$erdef	vcoerr		;virtual core not opened
$erdef	bserr		;illegal i/o channel
$erdef	linerr		;line too long
$erdef	flterr		;floating point error
$erdef	experr		;argument too large in exp
$erdef	fmterr		;data format error
$erdef	fixerr		;integer error
$erdef	bdnerr		;illegal number
$erdef	logerr		;transcendental error
$erdef	sqrerr		;imaginary square roots
$erdef	suberr		;subscript out of range
$erdef	minver		;can't invert matrix
$erdef	odd		;out of data
$erdef	onbad		;on statement out of range
$erdef	nederr		;not enough data in record
$erdef	iolerr		;integer overflow, for loop
$erdef	divby0		;division by 0

; cannot resume from following errors

$.equ.	errcc	,	tmptag

$erdef			;no run time system
$erdef	stmerr		;statement not found
$erdef	baderr		;illegal statement
$erdef	stperr		;stop
$erdef	errerr		;unimplemented code
$erdef	dimerr		;matrix dimension error
$erdef	prerrs		;using-string format error
$erdef	prner1		;bad number in print-using
$erdef	prner2		;print-using buffer overflow
$erdef	udmerr		;array without dim
$erdef	exittm		;return without gosub
$erdef	exitnr		;fnend without function call
$erdef	undfni		;undefined function called
$erdef	coserr		;illegal symbol
$erdef	tlopnv		;illegal verb
$erdef	tlnzsp		;illegal expression
$erdef	tlnoit		;illegal mode mixing
$erdef	tliffe		;illegal if statement
$erdef	tlconi		;illegal conditional clause
$erdef	tlnotf		;illegal function name
$erdef	tlqdum		;illegal dummy variable
$erdef	tlmfnd		;illegal fn redefinition
$erdef	tlrnnm		;illegal line number(s)
$erdef	moderr		;modifier error
$erdef	tlordt		;can't compile statement
$erdef	outoas		;expression too complicated
$erdef	funerr		;arguments don't match
$erdef	tltmaf		;too many arguments
$erdef	tlincd		;inconsistent function usage
$erdef	cpnsdf		;illegal def nesting
$erdef	cpupfr		;for without next
$erdef	cpufnx		;next without for
$erdef	cpupdf		;def without fnend
$erdef	cpuped		;fnend without def
$erdef	tljnky		;constant string needed
$erdef	tlnofn		;too few arguments
$erdef	sasyne		;syntax error
$erdef	safnos		;string is needed
$erdef	sasnoi		;number is needed
$erdef	tlurtp		;data type error
$erdef	tlxdim		;1 or 2 dimensions only
$erdef	fucore		;program lost-sorry
$erdef	reserr		;resume and no error
$erdef	dimed2		;redimensioned array
$erdef	tlidim		;inconsistent subscript use
$erdef	nogoto		;on statement needs goto
$erdef	eoserr		;end of statement not seen
$erdef	tlcntd		;what?
$erdef	tlprnm		;bad line number pair
$erdef	edbmce		;not enough core
$erdef	edexon		;execute only file
$erdef	nrnerr		;please use the run command
$erdef	edcone		;can't continue
$erdef	edarsv		;file exists-use replace
$erdef	kcorem		;k of core used
$erdef			;catastrophic error
$erdef			;pleaze say hello
$erdef	nonoim		;illegal in immediate mode
$erdef	tltrnk		;text truncated
$erdef	fielde		;field overflows buffer
$erdef	diserr		;illegal field variable
$erdef	noracs		;not a random access device
$erdef			;illegal magtape usage
$erdef	nomath		;wrong math package
$erdef	xcdcor		;maximum core exceeded
$erdef	scaerr		;scale factor interlock

; calls to the pseudo-monitor


$emdef	.write,writer		; write on a channel
$emdef	.core,corexx		; expand core
$emdef	.sleep,sleeper		; go to sleep
$emdef	.ttech,echomd		; enable echoing on a channel
$emdef	.ttnch,echods		; disable echoing on a channel
$emdef	.ttodt,ttyodt		; enable odt mode on a channel
$emdef	.ttrst,ttres		; cancel ^O and odt mode on channel
$emdef	.date,dater		; obtain date-time-problem anme
$emdef	.time,timer		; about the same
$emdef	.read,readxx		; read on a channel
$emdef	.stat,statxx		; get statistics (size/problem name)
$emdef	.name,namexx		; install problem name
$emdef	.exit,sysext		; delete temp file and exit
$emdef	.ttclo,ttclo
$emdef	.fork,forkxx		; split process
$emdef	.ctmp,ctmpxx		; copy temp files
$emdef	.rtmp,rtmpxx		; rename temp files
$emdef	.wait,waitxx		; wait for last child to die
$emdef	.exec,execxx		; run another process
$emdef	.sig,sigxx		; handle a signal
$emdef	.onsig,onsig		; catch interrupt/quit
$emdef	.offsig,offsig		; ignore interrupt/quit
$emdef	calfip,unxfip		; call fip processor

; file processor parameters

$.equ.	filseg	,512.		;size of file segment in bytes


; flag values for an open file's flag word
$.equ.	flgrnd	,100000		;file is random access type
$.equ.	flgkb	, 40000		;file is keyboard type
$.equ.	flgfrc	, 20000		;file is force type (not blocked)
;$.equ.		, 10000		;unused
$.equ.	flgpos	,  4000		;file's position needs checking
$.equ.	ddwlo	,  2000		;file is write locked
$.equ.	ddrlo	,  1000		;file is read locked
$.equ.	ddnfs	,   400		;file is non-file-structured

; low byte is the handler index

.iif	ndf	$list$	.list
