; The use and distribution of the information
; contained herein may be restricted.
;
title	ed,<editor>,24,19-jul-74,tge/tph/mhb

	org	xt,tldipt

	.word	docont	;cont(inue)
	.word	dolist	;list
	.word	dolinh	;list nh
	.word	dodele	;delete
	.word	doleng	;length
	.word	donew	;new
	.word	doold	;old
	.word	dorena	;rename
	.word	dorepl	;replace
	.word	dorun	;run
	.word	dorunh	;run nh
	.blkw		;was "assign"
	.word	dosave	;save
	.blkw		;was "deassign"
	.word	dounsa	;unsave
	.blkw		;catalog (now a ccl)
	.word	docomp	;compile
	.blkw		;was "hello"
	.word	dobye	;bye
	.blkw		;was "tape"
	.blkw		;was "key"
	.word	doapnd	;append
	.word	domore	;more to come...

	..	ppchai,rrrrr

	org	pn
	org	ed

	.globl	statbuf			;scratch area, in 'udata'
	.globl	syscb

	.globl	lststs
	nlflag	=	1
	crflag	=	2
	.globl	getag,getagd,getagn,edstor,ccint
	.globl	bitbuf,doccox,dobye
	.globl	edftch,basfrc,edfipn,basven
	.globl	lstop1,dltonn,dltonr,ederrf,edrsr1
	.globl	edclr,edendc,edfipk,edpus2
	.globl	edrsth,edscan,edtype,ederr,ederrn
	.globl	rtsrer,rtsret,r1schk,edctlh
	.globl	newjob,runim,r1sout,zotall
	.globl	edrun

	.globl	asknew,askold,readym
	.globl	printl,printc,opnr20
	.globl	sso,sso01,opni11,opni20
	.globl	clsr09,preset
	.globl	pushs3,dupls,rtsent,crlf,time07,date07
	.globl	prints,printm,ssix1
	.globl	tlgdfn,tlgfna,tl,tlgpds,tlcmwd,tlener
	.globl	tlptin,tlbegh,tlpdst,tlgln1,tlgenp
	.globl	tlgtok,newold,tlpair,catsua
	.globl	fltlen,catsup
	.globl	econom,edsave
	.globl	restor,closer,interp,interb,.math.
	.globl	tler18,edrest,getbuf,read.,write.
	.globl	getbyt,d.core,doscal
	.globl	catsus,scasup
	.globl	mupper,builds,pushs2
;editor-----------------------------------------------------------------
;processor for user's immediate commands
;the editor is entered at "newjob" by the scheduler when a terminal is
;first activated.  the editor enters the translator via calls "tl" and
;"tlc" with r1 and r6 stacks setup and also with core allocators pointers
;initialized.  the editor is reentered from the translator when the user
;executes any of the immediate commands.  some of these commands,
;such as run, cause the editor to call the run-time-system via a call
;to "rts".

baslo1 = '.+<256.*<'B!40>>
baslo2 = <'A!40>+<256.*<'S!40>>
baclo1 = '.+<256.*<'B!40>>
baclo2 = <'A!40>+<256.*<'C!40>>

indir.	=	trap+0.
wait.	=	trap+7.
exec.	=	trap+11.
exit.	=	trap+1.
signal	=	trap+48.
		sighup	=	1
		sigint	=	2
		sigqit	=	3

.macro	zt,name
.globl	tk'name
tk'name	=	tmptag
tmptag	=	tmptag+2
	org	zt,tk'name
	.word	do'name
.endm

tmptag	=	0

	zt	ccon
	zt	scal

	org	cclprg

	org	ed

domore:	movb	xxmore,r2	;which is special offset
	bmi	1$		;CCL
	jmp	@zt(r2)		;clean dispatch

1$:	jsr	pc,mupper	;convert buffer to upper case
	bic	#177600,r2	;clear set sign bit
	mov	cclprg(r2),r4	;get the wonder pointer
	tst	cclprg+2(r2)	;now see if UNIX or RSTS
	bne	7$		;UNIX
	movb	(r4)+,r3	;first byte is its length:
	mov	r3,r5		;copy length
	jsr	pc,builds	;and put this into a string
3$:	movb	(r4)+,(r3)+	;copy into string
	sob	r5,3$		;We know how many bytes
	jsr	pc,@(sp)+	;co-routine call to finish
	mov	(r2),(r1)	;kosher the string
	jsr	pc,pushs2	;the formula
	mov	clb(r0),r2	;get rest of buffer
	add	r0,r2		;properly biased
	mov	#corcmn+1,r4	;copy it into core common region
	clrb	corcmn		;the count
6$:	movb	(r2)+,(r4)	;move in a character
	cmpb	(r4)+,#endchr	;until end-of-line
	beq	4$		;found
	incb	corcmn		;increase count
	cmpb	corcmn,#176	;a finite limit
	blo	6$		;and then we truncate
4$:	tst	(sp)+		;remove "ipc"
	mov	#100000+30000.,-(r1)
	jmp	rrrrr		;just like a chain
7$:	.fork			;UNIX splitting act
		br 20$		;child return
	tstb	iosts		;see if we could fork
	beq	21$		;yes we could
	nofork	!fatal		;give the sucker an error
21$:	.wait			;wait for it to complete
	jmp	edctl		;smile and say ...
20$:	mov	clb(r0),r2	;get the rest of the line
	add	r0,r2		;unbias it
	mov	r2,@(r4)+	;save in proper place
23$:	cmpb	(r2)+,#endchr	;terminate it properly
	bne	23$
	clrb	-(r2)
	mov	r4,r1		;set up for exec
	mov	(r4),r0		;first must be progr. name
	.exec			;no return


newjob:	jsr	pc,catsus	;absolute core set-up
	bit	#jfonce,jobf	;filename specified?
	beq	1$		;no
	mov	usrsp,r4	;get filename
	mov	(r4)+,r2	;its pointer
	mov	r4,usrsp	;corrected now
	mov	r2,r4		;duplicate
	clr	r3		;get its byte count
2$:	inc	r3		;count a byte
	tstb	(r2)+		;rope a dope
	bne	2$		;...
	jsr	pc,builds
3$:	movb	(r4)+,(r3)+	;don't need to remember where
	bne	3$		;it starts
	jsr	pc,@(sp)+	;co-routine finish
	mov	(r2),(r1)	;mystical
	jsr	pc,pushs2	;    "
	clr	-(r1)		;line number unreal
	jmp	rrrrr		;patient etherized on table
1$:	br	edctl4		;start him up


dobye:
	jsr	pc,edrstd		;set up spda
	jsr	pc,zotall		;close all usaer files
	.exit					;and leave



;edpuss makes a string header block on r1 stack for problem names
edpuss:	mov	(r1)+,r0	;place where rts wants it
	bne	edpus1		;test for noname
edpus2:	mov	#eddumm,r0	;ahhh
edpus1:	mov	spda,r2		;where rts expects it
	jsr	pc,pushs3	;splay it out
	jmp	edrstd		;spda to r0, rts pc

;new prepares for brand new problem from the user
donew:	mov	#asknew,-(r1)	;get a file name out of him
	jsr	pc,newold	;if you can
	jsr	pc,edpuss	;make name into header
	jsr	pc,edclr	;clear old problem etc.
	jsr	pc,edscan	;install the name
	jsr	pc,catsup	;clear all variables
	bic	#edgofl,edflag	;clear go
	br	edctl4

doapnd:	jsr	pc,edtmpp	;check for non-compiled
	bis	#edapnd,edflag	;don't kill what you got
doold:	mov	#askold,-(r1)	;bargain for a file name
	jsr	pc,newold	;from the user
	jsr	pc,edpuss	;make name into header
compi8:	jsr	pc,opnr20	;scan the new name
	mov	#baschn,fqfil(r4);set the .bas channel
	jsr	r5,edfip1	;and call fip for
	+	baslo1		;for
	+	baslo2		;open
	+	opnfq
	bcc	1$		;still o.k.
	ioterr	!fatal		;couldn't get it
1$:	bit	#edapnd,edflag	;see if appending
	bne	20$		;yes, so don't destroy this image...
	.name			;no, so install the name problem name
	mov	#-baschn,fqfil(r4);set to reset all channels except this one
	jsr	r5,edfipk	;now call fip to
	+	rstfq		; reset any open channels
	jsr	pc,edclrf	;clear editor flags
	jsr	pc,catsup	;clear core and initialize it
	mov	#firqb,r4	;now restore the firqb pointer
20$:	jsr	r5,edoi10	;call for
	+	opni20		; opening (in terms of buffers) file
	bis	#edcomp,edflag	;set compile flag
	jsr	pc,edccts	;check for ^c first
edctl4:	jmp	edctl		;get to edctl
;the following commands destroy the current swap area contents
;by loading a new area from the disk, or by initializing the area.
;r and chain have two arguments, a statement # in binary, and a
;string header for a <filename>.  i.e. 
;	r1	statement #
;		header
;if header = 0, the file "noname" will be used.
;if statement # = 0, the first statement will be used.

dor1:	jsr	pc,tlpdst	;if not string, error; push str; read token
	tljnky	!fatal		;junk instead of data string
	bis	#linumf,stat(r0);tell la to get a line no
	jsr	pc,tlgenp	;skip if end of statement
	br	5$		;not end, there's a line no. argument too
	clr	-(r1)		;stack 0 in non-line no. case
	br	3$

5$:	jsr	pc,tlgln1	;stack a line #
3$:	mov	(r1)+,-(sp)	;move loc to sp stack
	jsr	pc,edpuss	;splay header, check for 0=noname
rrrrr1:	bis	#edgofl,edflag	;mark as load & go
	jsr	pc,dupls	;duplicate string, in case needed
	jsr	pc,opnr20	;for .bas, then try to open
	tstb	jobf		;^C pending?
	bmi	edctl4		;yes -forget this
rrrr2:	mov	(sp)+,fqnent(r4)	;line no. into firqb
	jsr	r5,edfip2	;look it up
	+	baclo1		; ".bac"
	+	baclo2		;   extension
		br 1$		;if there is already an extension, and it is not
				; .bac then we go here
	+	lokfq		;fip function
	tstb	iosts		;successful?
	bne	1$		;no - cannot run it
	movb	statbu+9.,r0	;upper bytes of length
	bic	#177400,r0	;minus garbage
	mov	statbu+10.,r1	;lower order
	div	#1000,r0	;into disk blocks
	mov	r0,fqsiz(r4)	;save in firqb
	movb	#bacchn,fqfil(r4)
	jsr	r5,edfipk	;now open .bac file
	+	opnfq		;fip function
	tstb	iosts		;good?
	bne	2$		;no - fatal at this date
	br	edrun		;run him.
1$:	mov	fqnent(r4),-(sp)	
	bit	#edgofl,edflag	;load & go?
	bne	compi8		; yes - try .bas if possilbe
2$:	mov	iosts,-(sp)	;screwed up!
	jsr	pc,catsus	;initialize everything
	jsr	pc,edclr	;close all files
	mov	(sp)+,iosts	;remember error
	fucore	!fatal		;program lost - sorry (ha ha)

rrrrr:	mov	(r1)+,(sp)	;start line no on sp (kill rts pc)
	beq	rrrrr1		;if start at 1st line then all o.k.
	bis	#100000,(sp)	;else flag as user entered line # to start at
	br	rrrrr1		;now go do it
;monitor entry - possibly from another run-time system
edrun:	jsr	pc,catsus	;abs core setup (and fpu on if any...)
	.name			;insure name is installed
	mov	#firqb,r4	;as if an open had just been done
	mov	fqnent(r4),-(sp);restore line number
	mov	fqsiz(r4),r0	;set up parameters for read
	bit	r0,#-77-1	;check for a valid size
	bne	ederrf		;if <0 or >16k, then error
	mov	r0,-(sp)	;save file size
	inc	r0		;correct for 1 block not in file
	bit	r0,#3		;check for even 1k increments
	bne	ederrf		;if not, then error
	cmp	r0,#10		;also check for at least 2k
	blt	ederrf		;if less then 2k then error
	asr	r0		;get number of
	asr	r0		;1k core blocks req'd
	mov	r0,xrb+xrlen	;set amount to ask for
1$:	jsr	pc,d.core	;now ask for the memory
	beq	edrba1		;no room
	edbmce			;buy more core
ederrf:	jsr	pc,catsus	;core image is suspect
	jsr	pc,edclr	;close all files
	fucore	!fatal		;so apologize for it

;code to do run commands
dorunh:	jsr	pc,tlgtok	;move token pointer
	br	dor2
dorun:	jsr	pc,mupper		;a filename?
	jsr	pc,tlgenp
	br	dor1		;has an arg so it means get another image
	jsr	pc,header	;means run current program
dor2:	clr	-(r1)		;indicate no arg
	mov	#run,-(sp)	;set success return address
chksca:	cmpb	scaval,scaupv	;do scaling factors match??
	bne	1$		;nope, so give error
	rts	pc		;yep, so return

1$:	scaerr	!fatal		;fatal scaling interrlock error
edrba1:	mov	(sp)+,r0	;put file size into r0
	mov	#xrb,r3		;parameter block
	swab	r0		;size times 256.
	asl	r0		;now bytes
	mov	#bootln,(r3)+	;first past the bootstrap
	clr	(r3)+		;bytcnt
	mov	#nstorg,(r3)+	;loc
	mov	#bacchn,(r3)+	;channel index
	clr	(r3)		;from start
	.read			;and read it
	tstb	iosts		;any error?
	bne	ederrf		;any errors here are very fatal!
	mov	r0,-10(r3)	;now the real length
	.read			;other parameters still good
	tstb	iosts		;any error?
	bne	ederrf		;still very fatal
	mov	#nstorg,r3	;r3 is pointer to hash, r1 stack
	mov	(r3)+,-(sp)	;save hash total on the stack
	mov	(r3),r1		;and then get r1 stack back
	add	r3,r1		;now relocate it
	asr	r0		;find # words in image read
	dec	r0		;less 1 for hash total spot
	clr	r5		;hash total will go here
1$:	add	(r3)+,r5	;compute hash total
	sob	r0,1$		;looping through core
	mov	(sp)+,r3	;get right checksum
	cmp	r5,r3		;do they match?
	beq	5$		;checksum ok
	br	ederrf		;die politely
5$:	cmp	(r1)+,(pc)+	;check "sysvee" and "basven"
	.byte	sysvee,basven
	bne	ederrf		;badd
	cmp	(r1)+,#sysvel	;"sysvel" o.k.?
	bne	ederrf		;baddd
	mov	#r5ring+<15.*2>,r5	;get pointer to restore csr's
	mov	#15.,r3		;count of csr's
4$:	mov	(r1)+,-(r5)	;now restore them
	add	#nstorg,(r5)	;relocated
	sob	r3,4$		;and looping
	cmpb	(r1)+,#fltlen	;check for correct floater size
	bne	10$		;error if no match
	jsr	r5,scasup	;o.k., so check and set scaling
	br	2$		;all o.k. and set up now
10$:	jsr	pc,catsus	;core image is suspect
	nomath			;not correct
	br	ederrf		;call error fatal

2$:	jsr	pc,edclr	;now close all files
	bis	#edfirs!edgofl,edflag;set flags for no .tmp and load and go
	jsr	pc,edccts	;test for ^c (and spda to r0)
; comments on .bac file structure:
;	@nstorg+0 is:	hash total of image
;	@nstorg+2 is:	r1 stack value of image
;			(relative to nstorg+2)
;
;	@r1 popping down is:	'sysvee' and 'basven'
;				'sysvel'
;				15 csr's relative to nstorg
;				math package type
edendc:	jsr	pc,edbufc	;deallocate and close bas file
	mov	#edflag,r2	;access to flags
	bic	#edcont!edapnd!edpres!edcomp!edeoff,(r2)	;clear the flag
	bit	#edgofl,(r2)	;if set run the image
	beq	run20		;no, back to command level
	mov	(sp)+,-(r1)	;run from here
	clr	tllino(r0)	;set this up as it
	jsr	pc,tlbegh	;have been if on-line
				;fall through to run

;((spta))=statement list pointer and = 0 if no entries on it.
;otherwise it is a pointer relative to spta to first word in a tag
;(statement header).  each tag link word is relative to its own location
;run ([statement#]) expects either 0 or a binary statement number as its argument.

run:	tst	(r1)		;see if he specified start statement
	bne	2$		;no so look it up
	mov	@spta,(r1)	;start at first statement
	br	run6		;and prepare to start it

2$:	bpl	1$		;if non-zero, but >0 then still o.k.
	bic	#100000,(r1)	;else make >0 and
1$:	jsr	r5,lstop1	;let listop do the work
	getfop			;get first header with #
	mov	getagv(r0),-(r1);maybe this is it
	bne	run7		;got it
	tst	(r1)+		;fix r1 back up
	stmerr	!fatal		;no such statement

run7:	sub	spta,(r1)	;relativize the header
run6:	bic	#edgofl!edimed!edcont,edflag	;clear load&go flag
	jsr	pc,ckpass	;ck, xlnk statements, reset vars
	bne	run66		;crosslink error may choke rts
	jsr	pc,zotall	;close all user files
rtsnt1:	mov	(r1)+,r5	;get the displacement
	add	spta,r5		;make absolute
	mov	#interp,-(sp)	;start the interpreter
	mov	#2,runlvl	;goto level 2 for rts normal
	jmp	rtsent		;now play nexts like stuff

zotall:	mov	#12.,-(sp)	;close any open files
2$:	mov	(sp),-(r1)	;channel # to close
	jsr	pc,closer	;close it if open
	dec	(sp)		;next channel
	bne	2$		;until we get to channel 0
	tst	(sp)+		;get rid of number on stack
	rts	pc
; run immediate mode statement

runim:	jsr	pc,chksca	;see if scale interlock says don't run
	mov	@spta,-(r1)	;start at first statement
	bis	#edimed,edflag	;as flag for ckpass
	bit	#edpres,edflag	;variables at least reset
	bne	1$		;all set
	jsr	pc,ckpass	;clear variable and crosslink
	br	2$		;no need do it again

1$:	jsr	pc,ckcont	;only crosslink
2$:	bne	3$		;if not in proper saape
	bic	#edimed,edflag	;let him get into his program
3$:	br	rtsnt1		;and away we go

run66:	tst	(r1)+		;pop off start loc
run20:	br	edctlh		;return

.enabl	lsb

;continue () calls rts without first clearing all of the user's variables.
doccon:	jsr	pc,doccox	; fork here
		br docont	; child returns here to CONTINUE
	br	edctl		; parent professes READY

docont:	mov	#edrstd,-(sp)	;will r0<=spda, then rts pc
3$:	jsr	pc,chksca	;see if scale is interrlocked
	bit	#edcont,edflag	;see if continuing allowed now
	bne	1$		;yep, no changes made to program
2$:	edcone	!fatal		;error -- cannot continue; prog changed


1$:	bic	#jfcc!jfccc!jfrts,jobf	;clear ^c for so we can execute
	bic	#edimed!edcont,edflag	;turn off immediate mode checking
	jsr	pc,ckcont	;crosslink and ck nexting
	bne	2$		;you have screwed it up
	mov	r1cont,r1	;get saved r1
	add	r1corg,r1	;make it abs
	jsr	pc,edrs01	;remove any strings left above
	jsr	pc,@(sp)+	;do the co-routine
	mov	(r1)+,r5	;get ipc back
	mov	spta,r4		;and a pointer to the text area
	add	r4,(r1)		;make scth absolute
	mov	(r1)+,scth	;store header
	mov	(r1)+,currio(r0);restore currio
	add	r4,r5		;make ipc absolute
	mov	#2,runlvl	;goto level 2 for running
	jmp	interb		;go baby go

.dsabl	lsb
;badswp is reentry from scheduler in case of catastrophic error

;here on i/o errors
ederrn:	jsr	pc,ederrs	;save ps and goto level 1
	bic	#edcomp!edapnd!edgofl,edflag	;i/o error while compiling kills it
	bit	#reeror,edflag	;to trap reentries
	bne	ederr3		;from close
	bis	#reeror,edflag	;to trap reentries
	jsr	pc,edbufc	;release the input buffer
	br	ederr3

;here on non-i/o errors
ederr:	jsr	pc,ederrs	;save ps and goto level 1
ederr3:	dec	r2		;were we compiling (level 1)?
	bne	1$		;if not then no deletion takes place
				;get rid of any partially completed statement
	mov	tllino(r0),-(r1);its number is here
	jsr	r5,lstop1	;delete only the pushpop
	dltpop
	tst	getagv(r0)	;any deletions?
	beq	1$		;no, skip making badcod
	jsr	pc,tlener	;remember text length; even up proptr
	jsr	pc,tlbegh	;set scth to first header this stmt.
	movb	#5,(r4)		;note bad statement in type
	inc	length-tagtyp(r4)	;one byte of code
	mov	spta,r5
	add	#tagtyp+badbyt,r5	;set up tag
	sub	r4,r5		;for psuedo pop
	mov	r5,pntr-tagtyp(r4)	;at badbyt
1$:	mov	usrsp,sp	;reset stack
	bic	#edgofl!reeror!edeoff!trnker,edflag	;record?
	br	edctlh		;trying to recover hdr space in errors doesnt work

docomp:	jsr	pc,edtmpp	;is it legal to save?
	jsr	pc,zotall	;collapse buffers
	bic	#edimed,edflag	;
	jsr	pc,ckpass	;clean up image
	bne	edctlh		;before writing it
	jsr	pc,savfqb	;read label
	jsr	pc,edwbac	;write .bac file
edctlc:				;symbol for continuation calls to tl
edctl:
;	jsr	pc,edrsth	;reset str hdr ptr to prev value
rtsret:
edctlh:	bit	#edcomp,edflag	;don't type ready if
	bne	rtsrer		;this is going to be a compile job
	jsr	pc,ready
rtsrer:	mov	spda,r0		;get base register for data area
	mov	#blinef,stat(r0);clear la's line buffer
	clr	base+bytcnt(r0)	;clear any remnants for rts buffer
edexit:	mov	#1,runlvl	;goto editor level
	jsr	pc,edccts	;see if ^c typed
	jmp	tl		;from beginning
ederrs:	mov	runlvl,r2	;get prior running level
	mov	#1,runlvl	;then goto level 1
	br	ederr5

edrsr1:	mov	r1corg,r1	;reset r1 stack
edrs01:	mov	spda,r0		;set base
	mov	r1,r4		;and remove headers
	br	edrshm

edrsth:	mov	spda,r0		;set up base
	mov	tlmind(r0),r4	;old pointer
	mov	r4,mdd(r0)	;posted so as to retrieve hdr spc
	add	r0,r4		;make abs
edrshm:	bic	#edcont,edflag	;r1 stack reset--cont continue
	mov	r0,r3		;clear any strings in hdr area or on r1 stack
ederr4:	add	(r3),r3		;next item
	cmp	r3,r4		;on stack?
	blo	ederr4		;yes, keep going
	sub	r0,r3		;no, make this beginning of post-r1 list
	mov	r3,(r0)		;and install in last pre-r1 link
ederr5:	jmp	edrstd		;spda to r0 then rts pc....

doleng:	clr	-(r1)		;length command --type #k on tty
	jsr	pc,sso		;select tty on channel 0 for output
	.stat			;get status
	mov	xrb+xrlen,r2	;current size
	cmp	r2,#10.		;2 digit number?
	blt	1$		;nope
	sub	#10.,r2		;yes, find 2nd digit
	mov	r2,-(sp)	;and save it
	mov	#'1,r2		;1st digit is 1
	jsr	pc,printc	;so print it
	mov	(sp)+,r2	;get back 2nd digit
1$:	add	#'0,r2		;make into ascii
	jsr	pc,printc	;and print digit
	kcorem	!fatal		;"k words of core used"

dounsa:	jsr	pc,savfqb	;get a firqb with argument parsed in it
	jsr	r5,edfip1	;delete a file
	+	baslo1
	+	baslo2
	+	dlnfq		;deleter
	bcc	1$
	ioterr	!fatal		;no such file--complain
1$:	jmp	edctl


header:	.date
	mov	#xrb+xrci+10.,r2
	mov	#5,r3
	mov	-(r2),-(sp)
	sob	r3,.-2
	mov	#5,r3
1$:	movb	(sp),r2
	beq	.+6
	jsr	pc,printc
	mov	(sp)+,r2
	swab	r2
	bic	#177400,r2
	beq	.+6
	jsr	pc,printc
	sob	r3,1$
	mov	#11,r2
	jsr	pc,printc
	jsr	r5,edsave
	clr	-(r1)
	jsr	pc,date07
	jsr	pc,prints
	mov	#11,r2
	jsr	pc,printc
	clr	-(r1)
	jsr	pc,time07
	jsr	pc,prints
	jsr	pc,crlf
	jmp	dltonr
;save([filename])
;make a .bas file ordered by statement # - requires
;completely reorganizing file on a statement by statement basis.

dosave:	jsr	pc,savfq	;get new name if any
	mov	#-1,fqerno(r4)	;do a normal lookup
	jsr	r5,edfip1	;no such if i mustn't
	+	baslo1
	+	baslo2
	+	lokfq		;look up .bas if any
	bcs	replac		;if not already saved
	edarsv	!fatal		;problem already saved,use replace

dorepl:	jsr	pc,savfq	;install new name
replac:	jsr	pc,edbasi	;set up channel and size 1
	jsr	r5,edfip1	;call fip for
	+	baslo1
	+	baslo2
	+	rstfq		;closing slot if needed
	movb	#crefq,fqfun(r4);set the create function
	jsr	r5,edoi10	;open it
	+	opni11		;(really cal file processor)
	mov	#basch,-(r1)	;open baschn
	jsr	pc,sso
	clr	-(r1)		;output all the statements
	mov	#77777,-(r1)	;0 to infinity
	mov	spda,r0
	jsr	r5,lstop2	;pseudo-list
	listnn
	jsr	pc,edbufc	;deallocate and close bas file
	jmp	edctl

savfq:	jsr	pc,edtmpp
savfqb:	jsr	pc,mupper	;a filename?
	jsr	pc,tlgpds	;we hope
	br	save1		;then use current one
	jsr	pc,edpuss	;spread out header
	mov	#baschn,r2	;set up editor channel
	jsr	pc,opnr20	;make a firqb
1$:	jmp	tlgtok		;next token please

save1:	jsr	pc,edfirq	;make one with current name
edbasi:	mov	#baschn,fqfil(r4)	;set up bas channel and size 1
	mov	#1,fqsiz(r4)
	rts	pc
.enabl	lsb

edbufc:	jsr	r5,edsave
	mov	#basch,-(r1)	;dealloc and close
	jsr	pc,sso01
	jsr	pc,clsr09
	br	10$

edclr:	mov	r4,-(sp)	;save old r4
	mov	#firqb+2,r4	;useful pointer
	mov	(r4)+,-(sp)	;save job
	mov	(r4),-(sp)	;fqfil
	clr	(r4)		;reset all
	mov	r4,-(sp)	;save this pointer for restoring
	cmp	-(r4),-(r4)	;and back it for edfipk
	jsr	r5,edfipk	;close all files
	+	rstfq
	mov	(sp)+,r4	;restore pointer now
	mov	(sp)+,(r4)	;fqfil back
	mov	(sp)+,-(r4)	;job
	mov	(sp)+,r4	;restore
edclrf:	bic	#edfirs+edetmp+edpres+edcont,edflag;and indicate no .tmp
	rts	pc

;edscan([filename])
;uses rts scan to parse and store a filename
;to name1 table

edscan:	jsr	r5,edsave	;protection against rts ravages
	jsr	pc,opnr20	;sorts it out, leaves in firqb
	.name			;install name
10$:	jmp	dltonr		;edrest,spda to r0,rts pc

.dsabl	lsb
;write .bac version - see reading of .bac for comments

edwbac:	.stat			;get status
	mov	xrb+xrlen,r3	;size
	asl	r3		;times 2 now
	asl	r3		;times 4 now for segment size
	dec	r3		;less 1 for 1st block
	mov	r3,fqsiz(r4)	;set size in segs for .bac file
	mov	#100000+exemod,fqmode(r4)
	mov	#bacchn,fqfil(r4)	;use channel 15.
	jsr	r5,edfip1	;call the fip processor
	+	baclo1
	+	baclo2
	+	crbfq		;and create/open it saving firqb
	movb	#.math.,-(r1)	;set math type (flt or int/dec)
	bne	1$		;if int/dec then leave it
	movb	scaupv,(r1)	;else set user's scaling factor
	negb	(r1)		;and make it negative
1$:	movb	#fltlen,-(r1)	;set floater size also
	mov	#r5ring,r5	;pointer to csr's
	mov	#15.,r2		;count of csr's
9$:	mov	(r5)+,-(r1)	;save a csr on the r1 stack
	sub	#nstorg,(r1)	;relocate
	sob	r2,9$		;looping...
	mov	#sysvel,-(r1)	;then system parameters
	mov	(pc)+,-(r1)
	.byte	sysvee,basven
	mov	#nstorg+2,r5	;get address of special spot
	mov	r1,(r5)		;save r1 stack here
	sub	r5,(r5)		;relocate
	clr	-(r5)		;back and clear hash spot
	mov	r5,r0		;and then copy the pointer
	swab	r3		;find # words to compute with
	mov	r3,r2		;and save it
10$:	add	(r0)+,(r5)	;and compute hash total
	sob	r3,10$		;looping through core...
	mov	#xrb,r3		;parameter block
	asl	r2		;bytes now
	mov	r2,datlen	;fill in magic header
	add	#bootln-20,datlen	;include boot-length
	mov	r2,(r3)+	;length
	mov	#bootln,(r3)+	;bytcnt
	mov	#bootst,(r3)+	;start here
	mov	#bacchn,(r3)+	;channel index
	clr	(r3)		;start from top
	.write			;and write it
	tst	-(r3)		;back up to channel index
	mov	#nstorg,-(r3)	;where from
	mov	r2,-(r3)	;how long
	.write			;write it out
	jsr	pc,edr1		;and finish up
	add	#15.+5.*2,r1	;correct r1 stack
	jsr	r5,edfipk	;close the file
	+	clsfq		;but do not remove the buffer!!
	br	edldf1
edoi10:	jsr	r5,edsave	;editor's call to buffer manager
	mov	#baschn,r2	;allocate buffer with size
	clr	-(r1)		;signal for device dependancy
	jsr	pc,@(r5)+	;call the correct routine
	jsr	r5,edrest	;restore r0,r2,r3,r4,r5
	tst	(r5)+		;skip the routine address
	rts	r5		;and return

;	renam ([filename]) command routine
dorena:	jsr	pc,mupper
	jsr	pc,tlgdfn	;demand a new name
	jsr	pc,edpuss	;splay header
	jsr	pc,edscan	;save the new name
	jmp	edctlc

;edtmpp sets up a tmp file if possible.
;return:	z=1 if no tmp file
;		z=0 if there is one

edtmpp:	jsr	pc,edldfl	;get flags
	bit	#edfirs,r2	;set after first call
	beq	1$		;first call since edclr
3$:	mov	r2,edflag	;put flags back in core
	bit	#edetmp,r2	;return z bit
	beq	10$		;error
	rts	pc		;o.k.

1$:	bic	#edetmp,edflag	;in case of error
	jsr	pc,edfirq	;clear furkbee
	jsr	r5,edfipk	;now create temp
	+	crtfq
	clr	bascur(r0)	;new text goes at beginning
	mov	#tmpch+1*iolen+base+flags,r2	;iob pointer
	add	r0,r2
	bicb	#wrtary,(r2)	;not changed yet
	jsr	pc,edldfl
	bis	#edfirs+edetmp,r2	;now we know that .tmp lives
	br	3$		;return z bit

10$:	edexon	!fatal		;no symbolic

;edldfl loads flags into r2, also sets up r0 to spda

edldfl:	mov	edflag,r2
	br	edldf1

;edfirq makes a firqb with current filename
;info, an extend op. .tmp channel, size=1, .tmp extension

edfirq:	jsr	pc,getbuf
	mov	#tmpchn,fqfil(r4)
	jsr	r5,edsave
	.date			;get problem name
	mov	#xrb+xrci,r0	;point to it
	mov	#10.,r2		;length of it
	mov	#firqb+fqnam1,r3	;where to put it
	movb	(r0)+,(r3)+
	sob	r2,.-2
	clrb	(r3)+		;null terminate
	jsr	r5,edrest	;restore registers
	inc	fqsiz(r4)	;set segment count properly
edldf1:	jmp	edrstd		;spda to r0, rts pc

;edfip - editors call to fip

;entry for non-file requests
edfipn:	jsr	pc,edfirq	;get furkbee
	br	edfipk		;no args except function

edfip:	jsr	pc,edfirq	;get firqb
edfip1:	mov	r3,-(sp)	;save a register
	clr	r3		;and say we are fip1
	br	edfipx		; common code
edfip2:	mov	r3,-(sp)	;save same register
	mov	#2,r3		;save we are fip2
edfipx:	mov	r0,-(sp)	;now save some more registers
	mov	r1,-(sp)	
	mov	r2,-(sp)
	mov	#firqb+fqnam1,r0
3$:	clr	r1		;extension seen
1$:	movb	(r0)+,r2
	beq	2$		;end of file name
	cmpb	r2,#'/		;
	beq	3$		;turn off extension
	cmpb	r2,#'.
	bne	1$
	mov	r0,r1		;extension seen - remember where
	br	1$
2$:	tst	r1		;Any extension?
	bne	4$		;yes
	dec	r0		;point to last bye
	movb	(r5)+,(r0)+	;fill in
	movb	(r5)+,(r0)+
	movb	(r5)+,(r0)+
	movb	(r5)+,(r0)+
	clrb	(r0)+		;null terminate
	add	r3,r5		;special return?
	br	5$		;restore
4$:	tst	r3		;special call?
	beq	10$		;no - just bump up r5 by 4
	inc	r5		;both extensions start with "."
	cmpb	(r5)+,(r1)+	;first initial character?
	bne	9$		;no
	cmpb	(r5),(r1)+	;next character the same?
	bne	9$		;no
	cmpb	1(r5),(r1)+	;last character the same?
	bne	9$		;no
	tstb	(r1)+		;extension over?
	beq	10$		;yes - all clear
9$:	tst	(r5)+		;return to alternate branch
	mov	(sp)+,r2	;restore registers
	mov	(sp)+,r1
	mov	(sp)+,r0
	mov	(sp)+,r3
	rts	r5		;and indicate special fail return
10$:	cmp	(r5)+,(r5)+	;past two words
5$:	mov	(sp)+,r2
	mov	(sp)+,r1
	mov	(sp)+,r0
	mov	(sp)+,r3	;restore r3 too

edfipk:	movb	(r5),fqfun(r4)	;function to firqb
	calfip			;execute request
	movb	iosts,r0	;get errors if any
	cmpb	r0,#notcls	;see if it was still open
	bne	5$		;ok if not
	movb	#rstfq,fqfun(r4);then close it by resetting
	calfip			;and try again
	br	edfipk

5$:	tst	(r5)+		;skip over function in call
	tst	r0		;any error?
	beq	edfner		;if not
	cmpb	r0,#nosuch	;is it a "no such file" error?
	bne	edferr		;no, so simply panic
	sec			;indicate no such file
edfner:	mov	spda,r0		;restore spda
	rts	r5

edferr:	ioterr	!fatal		;signal i/o error


;basget (address)		get a character from the
;				current .tmp file (which
;				will be made into the .bas file)
;edstor (char)			puts char in next sequential loc
;				in .tmp file and advances loc.
;				(stored in bascur).
;				edstor either write the character out or
;				ignores it depending on the compil flag
basget:	jsr	r5,edsave	;make some workspace
	clr	-(sp)		;flag for get entry
	br	basg01

edstor:	mov	r2,-(r1)	;match la conventions
	jsr	r5,edsave	;r0 at top of r6 stack
	mov	pc,-(sp)	;flag for put entry
	mov	spda,r0		;for convenient use
	mov	bascur(r0),-(r1);address to store at
basg01:	jsr	pc,edtmpp	;is there a .tmp now?
	mov	(r1)+,r5	;loc to 'get' from
	mov	r5,r2		;copy it to 2 regs
	bic	#-777-1,r5	;adx pointer - low bits
	bic	r5,r2		;block number here
	swab	r2		;get it down to size
	asr	r2		;segment to reference
	inc	r2		;fip starts at 1
	mov	spda,r0		;base for globals
	jsr	pc,baspfb	;iob to r3
	cmp	r2,curblk(r3)	;if seg already in buffer
	beq	2$		;no need diddle buffer
	jsr	pc,basf01	;force out old seg if modified
1$:	mov	r2,curblk(r3)	;new block
	tst	(sp)		;is it 'write'?
	beq	5$		;no, read
	tst	r5		;no read on 'write'ing
	beq	6$		;first byte of new block
5$:	jsr	pc,read.	;call for data
	jsr	pc,edr1		;check for any errors
6$:	bicb	#wrtary,flags(r3)	;indicate virgin
2$:	add	#basbuf,r5	;add in buffer adx
	add	r0,r5		;abs byte address
	tst	(sp)		;see if rd or wr
	bne	7$		;if wr
	clr	-(r1)		;avoid odd loc for r1
	bisb	(r5),(r1)	;read ch
	br	9$

7$:	movb	(r1),(r5)	;store new one
	bisb	#wrtary,flags(r3)	;set meddled bit
	clr	bytcnt(r3)	;signal this was a random access
	inc	bascur(r0)	;# stored
	tst	(r1)+		;pop arg
9$:	tst	(sp)+		;pos r/w switch
	jsr	r5,edrest	;restore
	rts	pc

;get iob pointer in r3

baspfb:	mov	#tmpch+1*iolen+base,r3	;rel
	add	r0,r3		;now abs
	mov	pntr(r3),curloc(r3)
	rts	pc


;force out the current segment

basfrc:	jsr	pc,baspfb	;iob ptr to r3
	bit	#edetmp,edflag	;is there a tmp file?
	beq	edcct1		;do nothing if not
basf01:	bitb	#wrtary,flags(r3)	;need to write it?
	beq	edcct1
	mov	length(r3),bytcnt(r3)	;set full write count
	jsr	pc,write.	;write subr
	bicb	#wrtary,flags(r3)	;virgin now
edr1:	tstb	iosts		;check for errors
	bne	edferr		;complain
edccts:	mov	spda,r0		;get data area base
	tstb	jobf		;see if ^c typed
	bpl	edcct1		;nope
	bic	#jfcc,jobf	;clear it
	bic	#edcomp!edapnd!edgofl!edeoff,edflag	;get input from tyt
	mov	#blinef,stat(r0);tell la about this
edcct1:	rts	pc
;edftch get a character either from the tty or from a .bas file,
;depending on the compile flag.
edftch:	jsr	r5,edsave	;protect other peoples r's
	jsr	pc,r1schk	;guarantee some stack
	br	getbyt
gbnone:	clr	-(r1)		;channel zero
	bit	#edcomp,edflag	;from tty or elsewhere?
	beq	gbnon1		;tty
	mov	#basch,(r1)	;channel for random place
gbnon1:	jsr	pc,sso01
	jsr	pc,ssix1

getbyt:	mov	spda,r2		;make a pointer
	add	#base,r2	;to the buffer
	dec	bytcnt(r2)	;one less char
	blt	gbnone		;get a new buffer full
	mov	r2,r0		;to work on
	add	curloc(r0),r0	;loc in buffer
	inc 	curloc(r2)	;update it
	clr	-(r1)		;put it on stack
	movb	(r0),(r1)	;bytewise that is
	jmp	usodt		;to variable csect

	tmporg	usodt		;overwritten by odt, if present
	jmp	dltonr		;edrest, spda to r0, rts pc
	unorg
;ckpass checking pass-invoked just before program is run.
;routine to link data statements, to cross link for & next statements,
;and to provide error checking for "for" statements and multi-line "def"
;being properly nested.  it scans the statement list and pushes for & multi-line
;defs.  on encountering a next it pops item which must be corresponding
;for--at which time it cross links them.  when encountering enddef it
;pops item which must be multi-line def. if correspondence fails it issues a
;complaint, continues scan but inhibits running.

ckpass:	jsr	pc,preset	;preset all variables to zero
	bis	#edpres,edflag	;and say that we did it
	jsr	pc,restor	;restore the data statements
	clr	waittm(r2)	;clear console tty wait time
	clr	oegtln(r2)	;no on error goto
	clr	resloc(r2)	;not recovering from errors
	clr	gosub(r2)	;not into gosub's now
	mov	#randy,rndm(r2)	;reset to random numbers
	mov	(r1)+,r5	;save start loc
	jsr	pc,edrsr1	;reset r1 stack so r1corg good top check
	mov	r5,-(r1)	;restore start loc
ckcont:	mov	r1,r1ring	;use for top of stack checking
	bic	#ckebit+ckdefb,edflag	;clear error flag
	mov	spta,r0		;begin scan
	mov	r0,r2		;want to keep spta in r2
cploo1:	tst	(r0)		;test link
	beq	cpdone		;end of statement list
	add	(r0),r0		;pick up link
	mov	r0,scth		;post for errors
	mov	r0,-(sp)	;keep a relative version
	sub	r2,(sp)		;make rel to spta, why not?
	tst	tagpul(r0)	;if 0 statement
	beq	cploop		;not really there
	clr	-(sp)		;place for arithmetic
	movb	tagtyp(r0),(sp)	;type to dispatch on
	asl	(sp)		;time two
	add	(sp)+,pc	;into pc
	br	cploop		;0 null - skip statement
	br	cploop		;1 array
	br	cpedef		;2 enddef
	br	cpnext		;3 next
	br	cploop		;4 data
	br	cploop		;5 error on compiling statement
	br	cppdef		;6 def-multi
	br	cppush		;7 for
	br	cpsldf		;10 single line def
	br	cploop		;11 end of dim statement
cppush:	mov	(sp),-(r1)	;save tag
	mov	(sp),-(r1)	;twice
cploop:	jsr	pc,r1schk	;guarantee r1 stack space
	mov	spta,r2		;restore in case of reloc
	mov	r2,r0		;remake pointer
	add	(sp)+,r0	;in r0
	br	cploo1
cpdone:	cmp	r1,r1ring	;if stack not back up
	beq	cpdon1		;some begins have not been ended
	add	r2,(r1)		;add spta
	mov	(r1)+,scth	;and r1 tells which ones
	tst	(r1)+		;and this tells which kind
	beq	cpudfc		;if def
	jsr	r0,cperor	;report error
	cpupfr			;non-fatal -- unpaired for
	br	cpdon2		;see if more 

cpudfc:	jsr	r0,cperor	;say error
	cpupdf			;non-fatal -- unpaired def
cpdon2:	mov	spta,r2		;reset base
	bis	#ckebit,edflag
	br 	cpdone		;back for more

cpdon1:	mov	spda,r0		;reset base
	bit	#ckebit,edflag	;set for exit
	rts	pc		;quit

cppdef:	bit	#ckdefb,edflag	;been a def unpaired so far?
	bne	cppde1		;yes, kick about two def in row
	bis	#ckdefb,edflag	;set flag to indicate in def
	clr	-(r1)		;indicate def with a zero
	mov	(sp),-(r1)	;push statement
	br	cploop

cppde1:	jsr	r0,cperor	;report error
	cpnsdf			;non-fatal -- nested def's
	br	cploop		;next statement
;must be a "def" on stack
cpedef:	bit	#ckdefb,edflag	;test ckdefb flag
	beq	cpedfc		;br if it's off
	bic	#ckdefb,edflag	;indicate out of def
	cmp	r1,r1ring	;ck for top of stack
	bne	cpede1		;was last item def?
cpedfc:	jsr	r0,cperor	;say error
	cpuped			;non-fatal -- unpaired "end-def" error
	br	cploop		;next statement

cpsldf:	mov	r0,r3		;treat one line def like both def and fnend
	br	cpede2

cpede1:	mov	(r1)+,r3	;pop off statement
	add	r2,r3		;make absolute
	tst	(r1)+		;must be 0
	bne	cpedf1		;previous item not a def
cpede2:	mov	(sp),r4		;stack has rel vs of current one
	add	tagpus(r3),r3	;here
	inc	r3		;skip ppujx
	br	cpnex2

cpedf1:	cmp	-(r1),-(r1)	;use this item somehow
	br	cpedfc
;must be a "for" on stack
cpnext:	cmp	r1,r1ring	;ck top of stack
	bne	cpnex1		;was last item for?
	br	cpnex3

cpnxte:	cmp	-(r1),-(r1)	;use it for sure later
cpnex3:	jsr	r0,cperor	;say error
	cpufnx			;non-fata -- unpaired "next"
	br	cploop		;next statement

cpnex1:	tst	(r1)+		;pop off statemtn
	mov	(r1)+,r4	;get previous header
	beq	cpnxte		;last item was def!
	add	r2,r4
	mov	r0,r3		;make temp for ptr
	mov	r4,r5		;and temp next
	add	tagpus(r3),r3	;abs ptr to push-pop
	add	tagpus(r5),r5	;and to one for next
	cmpb	(r3)+,(r5)+	;skip first byte in both
	cmpb	(r3)+,(r5)+	;compare high byte of variable
	bne	cpnxte		;bad nest
	cmpb	(r3)+,(r5)+	;now compare low bytes
	bne	cpnxte		;bad nest
	movb	(r5)+,(r3)+	;pass back the control block
	movb	(r5)+,(r3)+	;in one byte chunks
	mov	r0,-(r1)	;now for header to next pushpop
	sub	r2,(r1)		;needs to be relative
	swab	(r1)		;and in right order
	movb	(r1)+,(r5)+	;pass high byte
	movb	(r1)+,(r5)+	;and low
	sub	r2,r4		;next header to for pushpop
cpnex2:	mov	r4,-(r1)	;now do parallel opr 
	swab	(r1)
	movb	(r1)+,(r3)+	;high byte
	movb	(r1)+,(r3)+	;and low
	br	cploop		;continue scan

cperor:	bis	#ckebit,edflag	;flag "error occured"
	bit	#edimed,edflag	;announce error ?
	beq	1$		;yes, take first exist
	tst	(r0)+		;no, take second exit
1$:	rts	r0		;now exit

;	listop (s(1), e(1), s(2), e(2),...,s(n), e(n), n)
;	does all the work for list & listnh.
;	listop wants to be given statement binary
;	numbers for the first and last lines
;	to be typed, and the total number of such pairs
;	as indicated above.  searches the statement list for
;	statement >= start & calls operator 'til > end.
;	call:
;	jsr	r5,listop
;	operator
;	where operator is a jsr pc type subroutine
;	which does the work on each statement.
;	lstop1 and lstop2 are alternate entries
lstop1:	mov	(r1),-(r1)	;make end same as beginning
lstop2:	mov	#1,-(r1)	;indicate one pair
	clr	getagv(r0)	;clear answer accumulator
listop:	jsr	r5,edsave	;make elbow room
	mov	(r1)+,-(sp)	;# of argument sets
	beq	listnf		;no sets
listnp:	mov	spta,r4		;statement chain
listno:	tst	(r4)		;see if last tag processed
	beq	listnd		;if no statements
	add	(r4),r4		;go to next tag
	mov	r4,r2		;local version
	sub	spta,r4		;save unreloc link
	cmp	tagbin(r2),2(r1);cur < start?
	blt	listnl		;keep looking
	cmp	tagbin(r2),(r1)	;cur > end?
	bgt	listnd		;all done
	mov	@12(sp),r3	;operator address
	jsr	pc,(r3)		;call it to process this statement

listnl:	add	spta,r4		;make absolute
	br	listno

listnd:	cmp	(r1)+,(r1)+	;pop pair bounds
	dec	(sp)		;dec. count of pairs
	bne	listnp		;continue if more
listnf:	tst	(sp)+		;pop off count
	jsr	r5,edrest	;all done
	tst	(r5)+		;skip subroutine argument
	jmp	edfner		;reset r0 to current spda and exit..
;	list uses listop to pass through the program
;	with listnm operating on each statement to type
dolist:	jsr	pc,header	;type header line
dolinh:	clr	lststs		;clear listout status
	jsr	pc,tlpair
	clr	-(r1)		;channel zero (tty)
	jsr	pc,sso		;open for output
	jsr	pc,edtmpp	;is there a .tmp file?
	jsr	r5,listop	;pass over program
	listnm			;looking for ones to type
	br	dectlc		;long branch

listnn:	clr	r3		;make length 0
	bisb	tagtxl(r2),r3	;set up length pointer
	beq	listn2		;if no text don't type
	mov	tagtxt(r2),-(sp);and text pointer into file
	br	listn1

listnm:	clr	r3		;make register 0
	bisb	tagtxl(r2),r3	;set up length pointer
	beq	listn2		;if no text don't type
	mov	tagtxt(r2),-(sp);and text pointer into file
	cmpb	#5,tagtyp(r2)	;if an error line prefix
	bne	listn1		;(it's not)
	movb	#'?,r2		;its typeout with ?
	jsr	pc,printc	;print it
listn1:	tstb	jobf		;does he want to quit?
	bmi	listn3		;yes--this is as good a time as any
	mov	(sp),-(r1)	;txt ptr arg
	jsr	pc,basget	;possible disk ref & reloc
	mov	(r1)+,r2	;set up arg for printc
	bic	#177400,r2	;clear junk
	cmpb	r2,#12		;<NL>?
	bne	1$		;nope
	bis	#nlflag,lststs	;say saw NL
	br	9$		;skip the print
1$:	cmpb	r2,#015		;<cr>?
	beq	2$		;yep
	clr	lststs		;no specials
	br	8$
2$:	bit	#nlflag,lststs	;saw 'nl'
	beq	3$
	mov	#137,r2		;send arrow
	jsr	pc,printc
3$:	mov	#12,r2		;send nl
	br	8$
8$:
	jsr	pc,printc	;print it
9$:
	inc	(sp)		;next character
	sob	r3,listn1	;that all of them?
listn3:	tst	(sp)+		;remove the count
listn2:	br	edrstd		;spda to r0, rts pc
;ready () prints "ready cr lf" on user's tty

ready:	bit	#jfonce,jobf	;time to leave?
	beq	1$		;no
	jmp	dobye
1$:	mov	#readym,-(r1)	;arg for edtype
	.ttrst			;cancel ^o
edtype:	jsr	r5,edsave
	clr	-(r1)		;slot 0
	jsr	pc,sso		;opened
	mov	(r1)+,r2	;match conventions
	jsr	pc,printl	;print it
	br	dltonr		;edrest,spda to r0,rts pc
;	dlstmt has same call format as listop.  it uses
;	listop to pass over the program and dltone to remove
;	each undesirable statement.
dodele:	jsr	pc,tlpair	;get pairs
	jsr	pc,edtmpp	;insure symbolic exists
	jsr	r5,listop	;pass over program
	dltonn			;delete one statement, no cont allowed
dectlc:	jmp	edctlc

dltonn:
;	bic	#edcont,edflag	;modified program signal
dltone:	clrb	tagtxl(r2)	;clear text
dltpop:	mov	r2,getagv(r0)	;save that we got here
	jsr	r5,edsave	;make room
	mov	tagpul(r2),r5	;save tagpul for use later
	clr	tagpul(r2)	;chop off any push-pop is flag for absent statement
	movb	tagtyp(r2),r3	;type for dispatch
	asl	r3		;times two for words
	clrb	tagtyp(r2)	;reset statement type
	add	r3,pc		;dispatch
	br	dltonr		;0 null
	br	dltary		;1 array
	br	dlnoco		;2 enddef
	br	dlnoco		;3 next
	br	dltonr		;4 data
	br	dltonr		;5 error occured compiling statement
	br	dldefn		;6 multiline def
	br	dlnoco		;7 for
	br	dldefn		;10 single line def
;	br	dltonr		;11 end of dim---must be followed by dltonr!!
dltonr:	jsr	r5,edrest
edrstd:	mov	spda,r0		;restore data base reg
	rts	pc

dldefn:	add	tagpus(r2),r2	;pushpop ptr
	add	#5,r2		;over entr
	clr	r3		;for address
	bisb	(r2)+,r3	;hi byte
	swab	r3
	bisb	(r2)+,r3	;low byte
	add	spda,r3		;abs ptr to function block
	mov	sp,(r3)		;ref'd but not def'd: pos<>0
dlnoco:	;bic	#edcont,edflag	;no continuing, not crosslinked right
	br	dltonr
dltary:	tst	r5		;# bytes in dim statement
	beq	dltonr
	asr	r5		;# arrays
	add	tagpus(r2),r2	;pushpop ptr
	tst	(r2)+		;skip junk
dltar1:	dec	r5		;one less now
	beq	dltonr		;yep
	mov	(r2)+,r3
	swab	r3
	add	spda,r3		;make abs
	bicb	#refary!dimary,flags(r3)
	bisb	#refary,flags(r3)	;set to ref'd but not dim'd
	br	dltar1
;getxxx routines all assume spda is in r0.
;when user starts a line with a line number call getagd(binstatno)
;when compiling a statement, call getagn to get a header for
;it - i.e. for multiple statement lines:  1 call to getagd to
;remove old statement(s) with that line number and calls to
;getagn for each new statement on the line.
;if he is just referencing it call getag(binstatno).  in
;either case a header (possibly virgin) is returned.
;getagd(n)
;changes all statements with a given # to phantoms
getagd:	jsr	r5,lstop1	;work over all such statements
	dltone			;with delete operator
	rts	pc

;getagn(n)
;find first phantom with given statement # or makes one
getagn:	jsr	r5,lstop1	;work them over
	getnop			;with find first ph op
	br	getf1		;then if not make one

;getag(n)
;find first statement of any kind with #, or makes one
getag:	jsr	r5,lstop1	;work over n's with
	getfop			;get-first op
getf1:	tst	getagv(r0)	;it accumulated any here
	beq	getf2		;if none, make a new one
	mov	getagv(r0),-(r1);answer to stack
	rts	pc

getf2:	tst	-(r1)		;make one - save # for it
getag4:	mov	spta,r0		;prepare to talk about the program area
	mov	tagptr(r0),r2	;reserve space
	sub	#taglen,r2	;try for space
	cmp	r2,taglim(r0)	;enough available?
	bgt	getag3		;yep
	jsr	r5,econom	;storage controller
	+	tagnom		;get tag space
	br	getag4		;see if it is enough

getag3:	mov	r2,tagptr(r0)	;store it back for the next guy
	mov	spda,r0		;back to data area
	add	spta,r2		;make abs ptr.
	mov	(r1),r3		;get # back
	mov	r3,tagbin(r2)	;put it in new header
	clr	tagpul(r2)	;make sure it looks empty
	clr	tagtxl(r2)	;in both ways; kill type too
;now install it in proper place in list
;r2 contains statement header (with # filled in) & we
;need to find right place to link it into.
;if there are any with that #, it goes after them:
;i.e. get header of the last of them; otherwise
;get header of last statement which is smaller 
;than this new one.  so a search 0-# with
;operator to store the last will do
	clr	(r1)		;from beginning
	mov	r3,-(r1)	;through end current st.
	jsr	r5,lstop2	;search
	getsop			;save each time
	mov	getagv(r0),r3	;pick up ptr
	bne	getag5		;if any found there, link in
	mov	spta,r3		;otherwise the new one is first
getag5:	mov	(r3),(r2)	;mov old link
	beq	getag6		;if zero don't re-relativize it
	add	r3,(r2)		;make abls
	sub	r2,(r2)		;re-relativize it
getag6:	mov	r2,(r3)		;mov in new link
	sub	r3,(r3)		;relativize it
	mov	r2,-(r1)	;new one is value
	rts	pc

;getnop - listop operator to get first phantom
getnop:	tst	tagpul(r2)	;see if phantom
	bne	getsr		;no
;getfop - listop to get first - period
getfop:	tst	getagv(r0)	;if any already found
	bne	getsr		;quit
;getsop - listop to get last
getsop:	mov	r2,getagv(r0)	;save absolute pointer
getsr:	rts	pc

r1schk:	cmp	r1,#nstorg+20	;check for r1 stack size
	bhi	getsr		;if o.k., then just exit
r1sout:	jsr	r5,econom	;storage control
	+	r1snom		;stack space please
	rts	pc


doccox:	bit	#edetmp,edflag	; is there a temp file to copy?
	beq	1$		; no
	jsr	pc,basfrc	; clear the copy buffer
	mov	r3,r2		; get a relative pointer to it
	add	pntr(r3),r2	; here
	.ctmp			; copy the temp file
	tstb	iosts		; check if error
	bne	10$		; yes - error
1$:	.fork			; splitting act
		br	2$	; child return
	tstb	iosts		; could we fork?
	bne	10$		; no
	add	#2,(sp)	; we skip too
	rts	pc		; now
2$:	.sig
	+	sighup		; ignore hangups
	+	1
	.offsig			; interrupts and quits too
	.rtmp			; rename out temp file
	inc	detflg		; we are "detached"
	rts	pc		; no skip return
10$:	nofork	!fatal		; cannot fork


	global	<detflg,usrsp,datlen,bootln,bootst>

	tmporg	udata
bitbuf:	.blkb	<<linlen+7>/8.>
	unorg
	.end
