	.ident	/v7.0fp/
	.nlist	ttm

fpu=1

;necessary definitions for assembling the ots routines

r0=%0
r1=%1
r2=%2
r3=%3
r4=%4
r5=%5
sp=%6
pc=%7

	.macro	otswa

	seqno	= 	0	;eequence # for isn/lsn
	lnbuf	=	2	;line buffer address
	flist	=	4	;pointer to fdb list
	freesp	=	6	;pointer to start of free space
	topfre	=	10	;pointer to top of free space
	objfre	=	12	;pointer to free space prior to i/o
	fmtcln	=	14	;sp prior to i/o
	endex	=	16	;end= address
	errex	=	20	;err= address
	varad	=	22	;address of variable for i/o
	itemsz	=	24	;[ size in bytes ! type ] of i/o variable
	encadr	=	26	;address of array for encode
	enccnt	=	30	;count for encode/decode
	encdcd	=	32	;fbd status word for enc/dec
	userex	=	34	;user's exit address
	arrcnt	=	36	;repeat count for array transmission
	filptr	=	40	;pointer to active fdb
	fmtad	=	42	;pointer to start of format
	initsp	=	44	;initial sp
	enmlnk	=	46	;name link for traceback
	tdynam	=	50
	envirn	=	52	;environment data

	.endm

	.macro	fblock

	fdbst	=	0	;status word
	fdbcn	=	2	;fortran channel number (1-99)
	fdbbp	=	4	;pointer to buffer
	fdbfp	=	6	;pointer to file name
	fdbas	=	10	;address of associated variable
	fdbbc0	=	10	;high order size(seq.)
	fdbbc1	=	12	;low order size (seq.)
	fdbnr	=	12	;record count (random)
	fdbln	=	14	;link to next
	fdblp	=	16	;link to previous

;status bits:

	input	=	100000	;input / output (read only on random)
	random	=	040000	;random / sequential
	create	=	020000	;create random file
	append	=	010000	;open append / create (sequential)
	carctl	=	004000	;carriage control
	ascspc	=	002000	;special ascii mode
	binspc	=	001000	;special binary mode
	lstbin	=	000400	;last i/o binary
	flush	=	000200	;flush buffer after eos
	delete	=	000100	;delete file on close
	open	=	000040	;open flag
	rgood	=	000020	;backspace good
	raninp	=	000010	;input for random

fdbsiz	=	20	;20 bytes
bufsiz	=	1010	;512.+8. bytes
flnsiz	=	66.	;file name block

	.endm

	.macro	fbuff

	buffd	=	0	;file descriptor
	bufnu	=	2	;number of bytes unused
	bufnx	=	4	;next byte pointer
	buftr	=	6	;bytes this read.
	bufbf	=	10	;start of 512. byte buffer

	.endm

	.macro	errdef	

	intov	=	1	;integer overflow
	izdiv	=	2	;integer zero divide
	comper	=	3	;compiler generated error
	cmrnge	=	4	;computed goto out of range
	icerr	=	5	;input conversion error
	ocerr	=	6	;output conversion error
	fovrfl	=	7	;floating overflow
	fundfl	=	10	;floating underflow
	fzdiv	=	11	;floating zero divide
	ngsqrt	=	12	;negative square root
	undexp	=	13	;undefined exp. operator
	badlog	=	14	;log of # <= 0
	noargs	=	15	;wrong number of args.

	raftw	=	16	;read after write
	waftr	=	17	;write after read
	seqran	=	20	;sequential access to random file
	ioinio	=	21	;recursive i/o
	badchn	=	22	;bad channel number
	outcor	=	23	;out of core
	badopn	=	24	;bad open
	rewrnd	=	25	;rewinf to random file
	unfovr	=	26	;unformatted read overflows record
	ioerr	=	27	;i-o error
	ioeof	=	30	;eof on i/o
	setopn	=	31	;setfile on open file
	nobks	=	32	;cannot backspace
	nodef	=	33	;no define file
	ranwrt	=	34	;random write on read-only file
	recsiz	=	35	;random record overflow
	defopn	=	36	;define file on open file
	linbig	=	37	;line too big
	encrec	=	40	;encode/decode with more than 1 record
	infrmt	=	41	;infinite format loop
	fcerr	=	42	;format conversion error
	canpse	=	45	;cannot pause
	illins	=	46	;illegal instruction
	buserr	=	47	;bus error
	gsopen	=	50	;not open on get/set
	objbad	=	51	;bad object time format
	objbig	=	52	;core exceeded in object time format
	segvol	=	53

	.endm

	.macro	syscall
	
	.break	=	trap+17.
	.read	=	trap+3.
	.write	=	trap+4.
	.seek	=	trap+19.
	.exit	=	trap+1.
	.open	=	trap+5.
	.create	=	trap+8.
	.close	=	trap+6.
	.exece	=	trap+59.
	.fork	=	trap+2.
	.indir	=	trap+0.
	.signal	=	trap+48.
	.wait	=	trap+7.
	.stty	=	trap+31.
	.gtty	=	trap+32.
	.fstat	=	trap+28.
	.unlink	=	trap+10.

	.endm

	.macro	error	errnum
	emt	errnum
	.endm

	.psect	.text.,ins,shr
	.psect	.data.,dat
	.psect	.bss.,bss
	.psect
