#include "../h/em1.h"
{ (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
  Explicit permission is hereby granted to universities to use or duplicate
  this program for educational or research purposes.  All other use or dup-
  lication  by universities,  and all use or duplication by other organiza-
  tions is expressly prohibited unless written permission has been obtained
  from the Vrije Universiteit. Requests for such permissions may be sent to

       Dr. Andrew S. Tanenbaum
       Wiskundig Seminarium
       Vrije Universiteit
       Postbox 7161
       1007 MC Amsterdam
       The Netherlands

  Organizations wishing to modify part of this software for subsequent sale
  must  explicitly  apply  for  permission.  The exact arrangements will be
  worked out on a case by case basis, but at a minimum will require the or-
  ganization to include the following notice in all software and documenta-
  tion based on our work:

	    This product is based on the Pascal  system  developed  by
       Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
       of the Vrije Universiteit, Amsterdam, The Netherlands.
}
{$i256	: integer sets of 256 elements}

program decode(import,tables,export,output);
#ifdef STANDARD
label 9999;
#endif
const
	MAGIC0 = 172;
	MAGIC1 = 428;
	MAGIC2 = 684;
type
	byte	= 0..255;
	alfa2	= packed array[1..4] of char;
	message	= packed array[1..30] of char;
var
	mn	: array[byte] of alfa2;
	oneops	: set of byte;
	CAL	: byte;
	tables	: text;
	export	: text;
	import	: file of byte;

procedure fatal(b:integer; m:message);
begin
  writeln(output,'decode: import number ',b:0,': ',m);
#ifdef STANDARD
  goto 9999;
#endif
#ifndef STANDARD
  halt(-1);
#endif
end;

procedure init;
var	b	: byte;
	c	: char;
	i,n	: integer;
	m	: alfa2;
	zseen	: boolean;
begin
    reset(import);
    reset(tables);
    rewrite(export);
    for b:=0 to 255 do
	mn[b]:=' ???';
    n:=sp_fmnem; oneops:=[];
    while not eoln(tables) do readln(tables);
    readln(tables);
    while not eoln(tables) do readln(tables);
    readln(tables);
    while not eoln(tables) do
	begin m[1]:=' '; zseen:=false;
	    for i:=2 to 4 do
		read(tables,m[i]);
	    while not eoln(tables) do
		begin read(tables,c);
		    if c='z' then zseen:=true;
		end;
	    readln(tables);
	    mn[n]:=m;
	    if not zseen then oneops:=oneops+[n];
	    if m=' cal' then CAL:=n;
	    n:=n+1;
	end;
    { pseudo's }
    mn[ps_bss ]:=' bss';	mn[ps_con ]:=' con';
    mn[ps_end ]:=' end';	mn[ps_eof ]:=' eof';
    mn[ps_mes ]:=' mes';	mn[ps_exc ]:=' exc';
    mn[ps_exd ]:=' exd';	mn[ps_hol ]:=' hol';
    mn[ps_let ]:=' let';	mn[ps_pro ]:=' pro';
    mn[ps_rom ]:=' rom';	mn[ps_ima ]:=' ima';
    mn[ps_imc ]:=' imc';	mn[ps_fwp ]:=' fwp';
    mn[ps_fwa ]:=' fwa';	mn[ps_fwc ]:=' fwc';
end;

function getb:byte;
begin
  getb:=import^; get(import);
end;

function getw:integer;
var t	: packed record
	      case boolean of
		  false	: (b1,b2:byte);
		  true	: (j:integer)
	  end;
begin t.b1:=getb; t.b2:=getb; getw:=t.j end;

procedure getilb(b:byte);
var l	: integer;
begin if b=sp_ilb1 then l:=getb else l:=getw; write(export,l:0) end;

procedure getdlb(b:byte);
var l	: integer;
begin if b=sp_dlb1 then l:=getb else l:=getw; write(export,'.',l:0) end;

procedure getcst(b:byte);
var l	: integer;
begin
    if b<>sp_cst2 then l:=getb else l:=getw;
    if b=sp_cstm then l:=-l;
    write(export,l:0)
end;

procedure copystring;
var	l	: integer;
	b	: byte;
begin l:=getb;
    if l=255 then l:=getw;
    while l>0 do
	begin l:=l-1; b:=getb;
	    if (b<32) or (b>127) then
		begin write(export,'\');
		    write(export,chr(b div 64 + ord('0')));
		    write(export,chr(b mod 64 div 8 + ord('0')));
		    write(export,chr(b mod 8 + ord('0')))
		end
	    else
		begin
		    if (b=ord('"')) or (b=ord('\')) then
			write(export,'\');
		    write(export,chr(b))
		end
	end
end;

procedure copyalpha;
var	i	: integer;
	b	: byte;
begin
    write(export,';   ');
    for i:=1 to 8 do
	begin b:=getb; if b<>0 then write(export,chr(b)) end;
    writeln(export)
end;

procedure header;
var	i,g,p	:integer;
begin
    i:=getw;
    if i=MAGIC1 then
	begin g:=getw; p:=getw;
	    if g>0 then
		begin writeln(export,'; exported data labels:');
		    for i:=1 to g do copyalpha;
		    writeln(export)
		end;
	    if p>0 then
		begin writeln(export,'; exported procedures :');
		    for i:=1 to p do copyalpha;
		    writeln(export)
		end;
	    i:=getw;
	    if i<>MAGIC2 then
		fatal(i,'end of header (684) expected  ')
	end
    else
	if i<>MAGIC0 then
	    fatal(i,'magic number (172) expected   ')
end;

procedure getoperand(c1:char; opb:byte);
var	b	: byte;
begin write(export,c1); b:=getb;
    if (b >= sp_fcst0) and (b < sp_fcst0 + sp_ncst0) then
	write(export,b:0)
    else case b of
	sp_dlb1,sp_dlb2:
	    getdlb(b);
	sp_dnam:
	    copystring;
	sp_pnam:
	    begin
		if (opb<>CAL) and (opb<>ps_fwp) then write(export,'$');
		copystring
	    end;
	sp_cst1,sp_cstm,sp_cst2:
	    getcst(b);
	end
end;

procedure pseudo(b:byte);
var	no	: integer;
	b2	: byte;
begin
    case b of
	ps_end,ps_eof:
	    ;
	ps_ima,ps_imc,ps_exd,ps_hol,ps_fwa,ps_fwc,ps_fwp,ps_bss:
	    getoperand(' ',b);
	ps_exc,ps_let:
	    begin getoperand(' ',b); getoperand(',',b) end;
	ps_pro:
	    begin b2:=getb;
		if b2<>sp_pnam then
		    fatal(b2,'procedure name expected       ');
		write(export,' '); copystring;
		getoperand(',',b2);
		getoperand(',',b2);
	    end;
	ps_rom,ps_con,ps_mes:
	    begin no:=0; b2:=getb;
		while b2<>sp_cend do
		    begin
			if no=0 then write(export,' ') else write(export,',');
			if (b2 >= sp_fcst0) and
				(b2 < sp_fcst0 + sp_ncst0) then
			    write(export,b2:0)
			else case b2 of
			    sp_ilb1,sp_ilb2:
				begin write(export,'*'); getilb(b2) end;
			    sp_dlb1,sp_dlb2:
				getdlb(b2);
			    sp_cst1,sp_cstm,sp_cst2:
				getcst(b2);
			    sp_pnam:
				begin write(export,'$'); copystring end;
			    sp_scon:
				begin write(export,'"'); copystring;
				  write(export,'"')
				end;
			    sp_lcon:
				begin copystring; write(export,'L') end;
			    sp_dnam,sp_rcon:
				copystring
			    end;
			b2:=getb; no:=no+1;
		    end;
	    end;
    end
end;

procedure decode;
var	b	: byte;
begin b:=getb;
    if (b>=sp_filb0) and (b<sp_filb0+sp_nilb0) then
	write(export,b - sp_filb0:0)
    else if (b=sp_ilb1) or (b=sp_ilb2) then
	getilb(b)
    else
	begin
	    if (b=sp_dlb1) or (b=sp_dlb2) then
		begin getdlb(b); b:=getb end
	    else if b=sp_dnam then
		begin copystring; b:=getb end;
	    if (b>=sp_fmnem) and (b<=sp_lmnem) then
		begin write(export,mn[b]);
		    if b in oneops then getoperand(' ',b)
		end
	    else if (b>=sp_fpseu) and (b<=sp_lpseu) then
		begin write(export,mn[b]); pseudo(b) end
	    else
		fatal(b,'instruction or pseudo expected')
	end
end;

begin { main }
    init;
    header;
    while not eof(import) do
	begin decode; writeln(export) end;
#ifdef STANDARD
9999: ;
#endif
end.
