#include	"../h/local.h"

/*
 * (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * Explicit permission is hereby granted to universities to use or duplicate
 * this program for educational or research purposes.  All other use or dup-
 * lication  by universities,  and all use or duplication by other organiza-
 * tions is expressly prohibited unless written permission has been obtained
 * from the Vrije Universiteit. Requests for such permissions may be sent to
 * 
 *      Dr. Andrew S. Tanenbaum
 *      Wiskundig Seminarium
 *      Vrije Universiteit
 *      Postbox 7161
 *      1007 MC Amsterdam
 *      The Netherlands
 * 
 * Organizations wishing to modify part of this software for subsequent sale
 * must  explicitly  apply  for  permission.  The exact arrangements will be
 * worked out on a case by case basis, but at a minimum will require the or-
 * ganization to include the following notice in all software and documenta-
 * tion based on our work:
 * 
 *           This product is based on the Pascal  system  developed  by
 *      Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
 *      of the Vrije Universiteit, Amsterdam, The Netherlands.
 */

/*
 * This program converts the file 'tables' (standard input)
 * into 3 files:
 *	1.  an include file with definitions of the mnemonic constants
 *	2.  a C file with mnemonic info
 *	3.  a C file with optimising info.
 * Generation of a file can be suppressed by specifying
 * the appropriate option:
 *	-h  no define file
 *	-m  no mnem file
 *	-o  no opt file.
 */

#ifdef C7
#define	iip_cast		(int	*)
#define	EQ			=
typedef	struct	file		FILE;
#endif

#ifndef C7
#define	iip_cast		/* nothing */
#define	EQ			/* nothing */
#define	FILE			struct file
#endif

#ifndef CEM
#define	void			int
void	printf();
#endif

#ifdef CEM
void	printf(());
#endif

#define	NULL			0
#define	EOF			(-1)
#define	BUFSIZ			512
struct	file {
	int	fd;
	int	nleft;
	char	*nextp;
	char	buff[BUFSIZ];
};
FILE	outfile;
FILE	infile;

struct mnems {
	char	m_name[3];
	char	m_nminis;
	char	m_mbase;
	char	m_nshorties;
	char	m_sbase;
	char	m_obase;
	int	m_flags;
};

/* flagbits of m_flags */
#define MN0		0
#define MNS		01
#define MNL		02
#define MNXYZ		014
#define		MNX	004
#define		MNY	010
#define		MNZ	014
#define MNABCEM		0160
#define		MNA	0020
#define		MNB	0040
#define		MNM	0060
#define		MNC	0100
#define		MNE	0120
#define MNO		0200

struct pattern {
	struct element {
		char	instr;
		char	operand;
	}	sub[7];
	char	optkind;
	char	optbits;
};

struct const {
	char *name;
	int value;
} consttab[] EQ {
	"fmnem",	0,
	"nmnem",	0,
	"fpseu",	0,
	"npseu",	0,
	"filb0",	0,
	"nilb0",	0,
	"fcst0",	0,
	"ncst0",	0,
	"ilb1",		0,
	"ilb2",		0,
	"dlb1",		0,
	"dlb2",		0,
	"dnam",		0,
	"pnam",		0,
	"scon",		0,
	"rcon",		0,
	"cst1",		0,
	"cstm",		0,
	"cst2",		0,
	"lcon",		0,
	"cend",		0,
	0,		0,
};
#define	FPSEU	2	/*index in consttab*/

#define	EXCESS		33
#define CONLIM		(2*EXCESS)
#define ARANGE		17
#define ARITBASE	(CONLIM+4*ARANGE)

struct	mnems	mnemon[256];
struct	mnems	*lastmnem;
int	first[26];
int	count[26];
int	firstopt[256];
int	optcount[256];
int	peekc;
int	line		EQ 1;
int	h_flag		EQ 1;
int	m_flag		EQ 1;
int	o_flag		EQ 1;
char	deffile[]	EQ "em1.h";
char	mnemfile[]	EQ "mntab.c";
char	optfile[]	EQ "optab.c";
char	*progname;
char	curinstr;
int	optno;
int	infatal;

/*
 * forward function declarations
 */
int	getlett();
int	getchar();
int	getbyte();
int	optline();

/*
 * used library routines
 */
extern	int	atoi();
extern	int	creat();
extern	int	read();
extern	int	close();
extern	int	write();
extern	void	exit();

main (ac,av) char **av; {

	progname = av[0];
	while (--ac && **++av == '-')
		doflags(*av);
	if (!(h_flag || m_flag || o_flag)) return;
	firstpart();
	if (m_flag) writemnems();
	if (o_flag) dosecondpart();
	exit(0);
}

doflags (arg) char *arg; {
	register char *ap;

	ap=arg;
	while (*++ap)
		switch (*ap) {
		  case 'h':	h_flag = 0; break;
		  case 'm':	m_flag = 0; break;
		  case 'o':	o_flag = 0; break;
		  default:
			fatal("only legal flags are -[hmo]");
		}
}

firstpart () {
	register fd;

	/*
	 * Create and write the file em1.h
	 */
	if (h_flag) {
		if ((fd = creat(deffile,0644)) < 0)
			fatal("can't create em1.h");
		finit(&outfile,fd);
	}
	read_const();
	read_pseudo();
	read_instr();
	if (h_flag) {
		flush();
		if (close(outfile.fd) != 0)
			;
	}
}

read_const() {
	register struct const *cp;
	register char *p;
	register n;

	for (cp=consttab; cp->name; cp++) {
		p = cp->name;
		while (*p) {
			n = getchar();
			if (n != *p++)
				fatal("constant expected");
		}
		n = getbyte();
		cp->value = n;
		if (peekc != '\n')
			fatal("bad constant value");
		skipline();
		if (h_flag)
			printf("#define sp_%s %d\n",cp->name,n);
	}
	putchar('\n');
	if (getchar() != '\n')
		fatal("empty line expected");
	line++;
}

read_pseudo() {
	register c0,c1,c2;
	int n,pn;

	n = 0;
	for (;;) {
		if ((c0=getchar()) == '\n') {
			line++;
			if (h_flag)
				printf("#define sp_lpseu %d\n\n",
					--n + consttab[FPSEU].value);
			return;
		}
		checklett(c0);
		c1 = getlett();
		c2 = getlett();
		pn = getbyte();
		skipline();
		if (pn != n++)
			fatal("pseudo's not sorted on number");
		if (h_flag)
			printf("#define ps_%c%c%c %d\n",c0,c1,c2,
				pn + consttab[FPSEU].value);
	}
}

int inmnem(am) struct mnems *am; {
	register struct mnems *m;
	register c,flags;
	static curc;

	/*
	 * read one line of first part of tables.
	 * Syntax:
	 * mnm  flags  nmini  minibase  nshorties  shortiebase  otherbase
	 */
	m = am;
	if ((c=getchar()) == '\n') {
		line++;
		return(0);
	}
	checklett(c);
	if (c != curc) {
		if (c < curc)
			fatal("instructions not sorted");
		first[c - 'a'] = m-mnemon;
		curc = c;
	}
	++count[c - 'a'];
	m->m_name[0] = c;
	m->m_name[1] = getlett();
	m->m_name[2] = getlett();
	skiplayout();
	flags = 0;
	while ((c=getchar())!='\t' && c != ' ')
		switch(c) {
		default:
			fatal("bad flag");
		case '-':
			break;
		case 'a':
			null(flags&MNABCEM);
			flags =| MNA;
			break;
		case 'e':
			null(flags&MNABCEM);
			flags =| MNE;
			break;
		case 's':
			null(flags&MNS);
			flags =| MNS;
			break;
		case 'l':
			null(flags&MNL);
			flags =| MNL;
			break;
		case 'o':
			null(flags&MNO);
			flags =| MNO;
			break;
		case 'b':
			null(flags&MNABCEM);
			flags =| MNB;
			break;
		case 'm':
			null(flags&MNABCEM);
			flags =| MNM;
			break;
		case 'c':
			null(flags&MNABCEM);
			flags =| MNC;
			break;
		case 'x':
			null(flags&MNXYZ);
			flags =| MNX;
			break;
		case 'y':
			null(flags&MNXYZ);
			flags =| MNY;
			break;
		case 'z':
			null(flags&MNXYZ);
			flags =| MNZ;
			break;
		}
	m->m_flags  = flags;
	m->m_nminis = getbyte();
	m->m_mbase  = getbyte();
	m->m_nshort = getbyte();
	m->m_sbase  = getbyte();
	m->m_obase  = getbyte();
	skipline();
	if (h_flag)
		printf("#define op_%3.3s %d\n",m->m_name,m-mnemon);
	return(1);
}

read_instr() {
	register struct mnems *m;

	m = mnemon;
	m->m_name[0] = '-';
	m->m_name[1] = '-';
	m->m_name[2] = '-';
	m->m_flags = MNZ;		/* ???? */
	while (inmnem(++m))
		;
	if (h_flag)
		printf("#define sp_lmnem %d\n\n",m-mnemon-1);
	lastmnem = m;
}

writemnems () {
	register struct mnems *mnem;
	register i;
	register *p;

	if ((i = creat(mnemfile,0644)) < 0)
		fatal("can't create mnems-file");
	finit(&outfile,i);
	printf("int mnemon[][5] {\n");
	for (mnem = mnemon; mnem <= lastmnem ; mnem++) {
		p = iip_cast mnem;
		for (i=0; i < ((sizeof *mnem)>>1); i++)
			printf("\t%d,",*p++);
		putchar('\n');
	}
	printf("};\n");
	flush();
	if (close(outfile.fd) != 0)
		;
}

checklett(c) {

	if (c <'a' || c >'z')
		fatal("bad letter");
}

null(word) {

	if(word != 0)
		fatal("overspecified flag");
}

skiplayout() {
	register c;

	while ((c=getchar())=='\t'||c==' ')
		;
	peekc = c;
}

int getlett() {
	register c;

	c = getchar();
	checklett(c);
	return(c);
}

int getbyte() {
	char buf[10];
	register char *p;
	register c;

	skiplayout();
	p = buf;
	while((c=getchar())>= '0' && c <= '9')
		*p++ = c;
	peekc = c;
	*p=0;
	c = atoi(buf);
	if ( c < 0 || c > 255 )
		fatal("number too large");
	return(c);
}

skipline() {
	while (getchar() != '\n')
		;
	peekc = getchar();
	line++;
}

dosecondpart () {
	register i,last;

	/*
	 * Process second part of tables that contain optimisations
	 * and produce output.
	 */

	if ((i = creat(optfile,0644)) < 0)
		fatal("can't create opts-file");
	finit(&outfile,i);
	printf("int pattern[][8] {\n");
	while (optline())
		;
	last = lastmnem - mnemon;
	printf("};\n\nint firstopt[] {\n");
	for(i=0; i<=last; i++)
		printf("\t%d,\n",firstopt[i]);
	printf("};\n\nint optcount[] {\n");
	for(i=0; i<=last; i++)
		printf("\t%d,\n",optcount[i]);
	printf("};\n");
	flush();
	if (close(outfile.fd) != 0)
		;
}

int inpart(ap) struct element *ap; {
	register struct element *p;
	register c,i;
	int ad1,ad2,op;
	char buf[4];
	int retval;
	int mnemlookup();

	/*
	 * read one part of an optimisation line
	 */

	p = ap;
	skiplayout();
	c = getchar();
	if (c == '-') {
		p->instr = 0;
		p->operand = 0;
		return(0);
	}
	checklett(c);
	buf[0] = c;
	buf[1] = getlett();
	buf[2] = getlett();
	buf[3] = 0;
	p->instr = mnemlookup(buf);
	skiplayout();
	c = getchar();
	if (c=='@') {
		retval = 1;
		c = getchar();
	} else
		retval = 0;
	if (c == '*') {
		p->operand = 0;
		return(retval);
	}
	/*
	 * there is an operand, it could start with an 'a' or a digit
	 */
	if (c>= '0' && c<= '9' || c=='-') {
		buf[0] = c;
		i=1;
		while((c=getchar())>='0' && c<='9')
			buf[i++] = c;
		buf[i] = 0;
		i = atoi(buf);
		p->operand = i+EXCESS;
		peekc = c;
		return(retval);
	}
	/*
	 * It should be an 'a' by now.
	 */
	if (c != 'a')
		fatal("bad letter in operand of optimisation");
	c = getchar();
	if (c<'0' || c>'3')
		fatal("In Ax x should be 0,1,2 or 3");
	ad1 = c - '0';
	c = getchar();
	switch(c) {
	default:
		fatal("bad char after Ax");
	case ' ':
	case '\t':
	case '\n':
		peekc = c;
		p->operand = CONLIM + ad1*ARANGE +ARANGE/2;
		return(retval);
	case '+':
		op = 0;	break;
	case '-':
		op = 1;	break;
	case '*':
		op = 2;	break;
	case '/':
		op = 3;	break;
	}
	c = getchar();
	if ( c>='0' && c<='9') {
		peekc = c;
		ad2 = getbyte();
		if ( ad2>ARANGE/2 )
			fatal("offset too big");
		if (op > 1)
			fatal("bad char between Ax and number");
		op = 1 - 2*op;
		/*
		 * now op = -1 for char '-'
		 *          +1 for char '+'
		 */
		p->operand = CONLIM + ad1*ARANGE + ARANGE/2 + op*ad2;
		return(retval);
	}
	if ( c != 'a' )
		fatal("bad char after operator");
	c = getchar();
	if (c <'0' || c >'3')
		fatal("bad digit after 'a' after operator");
	ad2 = c - '0';
	p->operand = ARITBASE + (op<<4) + (ad1<<2) + (ad2);
	return(retval);
}

int optline () {
	struct pattern pattern;
	register i;
	register *p;

	/*
	 * Read one optimisation and produce output for it.
	 */
	if (peekc<0)
		return(0);
	/*
	 * not yet at eof
	 */
	pattern.optbits = 0;
	for (i=0;i<7;i++)
		if (inpart(&pattern.sub[i]))
			pattern.optbits =| (1<<i);
	skiplayout();
	if (peekc!='\n')
		pattern.optkind = getbyte();
	else
		pattern.optkind = 0;
	skipline();
	if (pattern.sub[0].instr != curinstr) {
		curinstr = pattern.sub[0].instr;
		firstopt[curinstr&0377] = optno;
	}
	++optcount[curinstr&0377];
	p = iip_cast &pattern;
	for (i=0; i < ((sizeof pattern)>>1); i++)
		printf("\t%d,",*p++);
	putchar('\n');
	optno++;
	return(1);
}

int mnemlookup(m) char *m; {
	register char *key;
	register struct mnems *mnem;
	register candidates;

	key = m;
	candidates = count[*key - 'a'];
	mnem = &mnemon[first[*key++ - 'a']];
	while (candidates--) {
		if (mnem->m_name[1] == *key++ &&
		    mnem->m_name[2] == *key)
			return(mnem-mnemon);
		mnem++;
		key--;
	}
	fatal("bad mnemonic in optimisation");
}

/* ------------------- IO routines -------------------------- */

finit(af,fd) FILE *af; {
	register FILE *f;
	/*
	 * initialize file structure
	 */
	f = af;
	f->fd = fd;
	f->nleft = 0;
	f->nextp = 0;
}

int fill() {
	/*
	 * read in next block
	 */
	infile.nextp = infile.buff;
	return(infile.nleft = read(infile.fd,infile.buff,BUFSIZ) - 1);
}

int getchar() {
	register c;

	if(peekc) {
		c = peekc;
		peekc = 0;
	} else {
		if (--infile.nleft < 0)
			if (fill() < 0)
				return(EOF);
		c = *(infile.nextp)++ & 0377;
		if ( c >= 'A' && c <= 'Z' )
			c =+ 'a' - 'A';
	}
	return(c);
}


flush() {
	/*
	 * write out a (partial) filled block; fatal if error
	 */
	if (outfile.nextp)
		if (write(outfile.fd,outfile.buff,outfile.nextp-outfile.buff) < 0)
			if (infatal==0)
				fatal("write error");
	outfile.nextp = outfile.buff;
	outfile.nleft = BUFSIZ;
}

putchar(c) {
	/*
	 * write next character
	 */
	if (--outfile.nleft < 0) {
		flush();
		--outfile.nleft;
	}
	*(outfile.nextp)++ = c;
}

fatal(s) char *s; {

	infatal++;
	flush();
	finit(&outfile,2);
	printf("%s - error in line %d: %s\n",progname,line,s);
	flush();
	exit(-1);
}
