#include "../h/local.h"
#include "../h/em1.h"

{ (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
  Explicit permission is hereby granted to universities to use or duplicate
  this program for educational or research purposes.  All other use or dup-
  lication  by universities,  and all use or duplication by other organiza-
  tions is expressly prohibited unless written permission has been obtained
  from the Vrije Universiteit. Requests for such permissions may be sent to

       Dr. Andrew S. Tanenbaum
       Wiskundig Seminarium
       Vrije Universiteit
       Postbox 7161
       1007 MC Amsterdam
       The Netherlands

  Organizations wishing to modify part of this software for subsequent sale
  must  explicitly  apply  for  permission.  The exact arrangements will be
  worked out on a case by case basis, but at a minimum will require the or-
  ganization to include the following notice in all software and documenta-
  tion based on our work:

	    This product is based on the Pascal  system  developed  by
       Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
       of the Vrije Universiteit, Amsterdam, The Netherlands.
}

{if next line is included the compiler itself is written in standard pascal}
{#define	STANDARD	1}

{if next line is included, then code is produced for segmented memory}
{#define	SEGMENTS	1}

{Author:	Johan Stevenson			Version:	31}
{$l- : no source line numbers}
{$r- : no subrange checking}
{$a- : no assertion checking}
#ifdef STANDARD
{$s+ : test conformancy to standard}
#endif

program pem(input,em1,errors);
{ This Pascal compiler produces EM1 code as described in
   - A.S.Tanenbaum, J.W.Stevenson & H. van Staveren,
	"Description of a experimental machine architecture for use of
	 block structured languages" Informatika rapport 54.
  A description of Pascal is given in
   - K.Jensen & N.Wirth, "PASCAL user manual and report", Springer-Verlag.
  Several options may be given in the normal pascal way. Moreover,
  a positive number may be used instead of + and -. The options are:
	a:	interpret assertions (+)
	c:	C-type strings allowed (-)
	d:	type long may be used (-)
	f:	size of reals in words (2)
	i:	controls the number of bits in integer sets (16)
	l:	insert code to keep track of source lines (+)
	o:	optimize (+)
	p:	size of pointers in words (1)
	r:	check subranges (+)
	s:	accept only standard pascal programs (-)
	t:	trace procedure entry and exit (-)
	u:	treat '_' as letter (-)
}
{===================================================================}
#ifdef STANDARD
label 9999;
#endif

const

{powers of two}
  t7		= 128;
  t8m1		= 255;
  t8		= 256;
  t14		= 16384;
  t15m1		= 32767;

{EM-1 sizes}
  bytebits	= 8;
  wordbits	= 16;
  wbm1		= 15;		{wordbits-1}
  minint	= -t15m1;
  maxint	= t15m1;
  maxintstring	= '0000032767';
  maxlongstring	= '2147483647';

  bytesize	= 1;
  wordsize	= 2;
  addrsize	= wordsize;
  pnumsize	= wordsize;
  shortsize	= wordsize;
  longsize	= 4;
#ifdef SFLOAT
  floatsize	= 4;
#endif
#ifndef SFLOAT
  floatsize	= 8;
#endif

{Pascal sizes. for ptrsize, realsize and fhsize see handleopts}
  { EM-1 requires that objects greater than a single byte start at  a
    word  boundary,  so their address is even.  Normally, a full word
    is also allocated for objects of a single byte.  This extra  byte
    is really allocated to the object, not only skipped by alignment,
    i.e. if the value false is assigned to a  boolean  variable  then
    both bytes are cleared.  For single byte objects in packed arrays
    or packed records, however, only one byte is allocated,  even  if
    the next byte is unused.  Strings are packed arrays.  The size of
    pointers is 2 by default, but can be changed at  runtime  by  the
    p-option.   Floating point numbers in EM-1 currently have size 4,
    but this might change in the future to 8.   The  default  can  be
    overwritten  by  the f-option.  The routines involved with align-
    ment are 'even', 'address' and 'arraysize'.
  }
  boolsize	= bytesize;
  charsize	= bytesize;
  intsize	= shortsize;
  buffsize	= 512;
  maxsetsize	= 4096;		{t15 div bytebits}

{maximal indices}
  idmax		= 8;
  fnmax		= 14;
  smax		= 72;
  rmax		= 72;
  imax		= 10;

{opt values}
  off		= 0;
  on		= 1;

{for push and pop: }
  global	= false;
  local		= true;

{set bounds}
  minsetint	= 0;
  maxsetint	= 15;		{default}

{constants describing the compact EM1 code}
  MAGICLOW	= 172;
  MAGICHIGH	= 0;
  meserror	= 0;
  mesoptoff	= 1;
  mesvirtual	= 2;
  mesreg	= 3;
  meslino	= 4;
  mesfloats	= 5;

{ASCII characters}
  tab		= 9;
  newline	= 10;
  hortab	= 11;
  formfeed	= 12;
  carret	= 13;

{miscellaneous}
  maxsg		= 127;		{maximal segment number}
  maxcharord	= 127;		{maximal ordinal number of chars}
  maxargc	= 13;		{maximal index in argv}
  rwlim		= 34;		{number of reserved words}
  spaces	= '        ';
  emptyfnam	= '              ';

{-------------------------------------------------------------------}
type
{scalar types}
  symbol=	(comma,semicolon,colon1,colon2,notsy,lbrack,ident,
		 intcst,charcst,realcst,longcst,stringcst,nilcst,minsy,
		 plussy,lparent,arrow,arraysy,recordsy,setsy,filesy,
		 packedsy,progsy,labelsy,constsy,typesy,varsy,procsy,
		 funcsy,beginsy,gotosy,ifsy,whilesy,repeatsy,forsy,
		 withsy,casesy,becomes,starsy,divsy,modsy,slashsy,
		 andsy,orsy,eqsy,nesy,gtsy,gesy,ltsy,
		 lesy,insy,endsy,elsesy,untilsy,ofsy,dosy,
		 downtosy,tosy,thensy,rbrack,rparent,period
		);			{the order is important}
  chartype=	(lower,upper,digit,layout,tabch,
		   quotech,dquotech,colonch,periodch,lessch,
		   greaterch,lparentch,lbracech,
						{different entries}
		 rparentch,lbrackch,rbrackch,commach,semich,arrowch,
		   plusch,minch,slash,star,equal,
						{also symbols}
		 others
		);
  standpf=	(pread,preadln,pwrite,pwriteln,pput,pget,
		 preset,prewrite,pnew,pdispose,ppack,punpack,
		 pmark,prelease,ppage,phalt,
						{all procedures}
		 feof,feoln,fabs,fsqr,ford,fchr,fpred,fsucc,fodd,
		 ftrunc,fround,fsin,fcos,fexp,fsqrt,fln,farctan
						{all functions}
		);			{the order is important}
  libmnem=	(ELN ,EFL ,CLS ,WDW ,		{input and output}
		 OPN ,GETX,RDI ,RDC ,RDR ,RDL ,RLN ,
						{on inputfiles}
		 CRE ,PUTX,WRI ,WSI ,WRC ,WSC ,WRS ,WSS ,WRB ,
		 WSB ,WRR ,WSR ,WRL, WSL, WRF ,WRZ ,WSZ ,WLN ,PAG ,
				{on outputfiles, order important}
		 ABR ,RND ,SIN ,COS ,EXPX,SQT ,LOG ,ATN ,
						{floating point}
		 ABI ,ABL ,BCP ,BTS ,NEWX,SAV ,RST ,INI ,HLT ,
		 ASS ,GTO ,PAC ,UNP, DIS, ASZ, MDI, MDL
						{miscellaneous}
		);
  structform=	(scalar,subrange,pointer,power,files,arrays,carray,
		 records,variant,tag);		{order important}
  structflag=	(spack,withfile);
  identflag=	(refer,used,assigned,noreg,samesect);
  idclass=	(types,konst,vars,field,carrbnd,proc,func);
  kindofpf=	(standard,formal,actual,extrn,forwrd);
  where=	(blck,rec,wrec);
  attrkind=	(cst,fixed,pfixed,loaded,ploaded,indexed);
  twostruct=	(eq,subeq,ir,ri,il,li,lr,rl,es,se,noteq);  {order important}

{subrange types}
  sgrange=	0..maxsg;
  idrange=	1..idmax;
  fnrange=	1..fnmax;
  rwrange=	0..rwlim;
  byte=		0..t8m1;

{pointer types}
  sp=	^structure;
  ip=	^identifier;
  lp=	^labl;
  bp=	^blockinfo;
  np=	^nameinfo;

{set types}
  sos=		set of symbol;
  setofids=	set of idclass;
  formset=	set of structform;
  sflagset=	set of structflag;
  iflagset=	set of identflag;

{array types}
  alpha =packed array[idrange] of char;
  fntype=packed array[fnrange] of char;

{record types}
  errec=record
    erno:integer;		{error number}
    mess:alpha;			{identifier parameter if required}
    mesi:integer;		{numeric parameter if required}
    chno:integer;		{column number}
    lino:integer;		{line number}
    linr:integer;		{relative to start of this (included) file}
    orig:integer;		{idem, but before preprocessing}
    fnam:fntype;		{source file name}
  end;

  position=record		{the addr info of certain variable}
    ad:integer;			{for locals it is the byte offset}
    lv:integer;			{the level of the beast}
#ifdef SEGMENTS
    sg:sgrange			{only relevant for globals (lv=0) }
#endif
  end;

{records of type attr are used to remember qualities of
  expression parts to delay the loading of them.
  Reasons to delay the loading of one word constants:
	- bound checking
	- set building.
  Reasons to delay the loading of direct accessible objects:
	- efficient handling of read/write
	- efficient handling of the with statement.
}
  attr=record
    asp:sp;				{type of expression}
    packbit:boolean;			{true for part of packed structure}
    ak:attrkind;			{access method}
    pos:position;			{sg, lv and ad}
    {If ak=cst then the value is stored in ad}
  end;

  nameinfo=record		{one for each separate name space}
    nlink:np;			{one deeper}
    fname:ip;			{first name: root of tree}
    case occur:where of
      blck:();
      rec: ();
      wrec:(wa:attr)		{name space opened by with statement}
  end;

  blockinfo=record	{all info of the current procedure}
    nextbp:bp;		{pointer to blockinfo of surrounding proc}
    lc:integer;		{data location counter (from begin of proc) }
    ilbno:integer;	{number of last local label}
    forwcount:integer;	{number of not yet specified forward procs}
    lchain:lp;		{first label: header of chain}
  end;

  structure=record
    size:integer;			{size of structure in bytes}
    sflag:sflagset;			{flag bits}
    case form:structform of
      scalar  :(scalno:integer;		{number of range descriptor}
		fconst:ip		{names of constants}
	       );
      subrange:(min,max:integer;	{lower and upper bound}
		rangetype:sp;		{type of bounds}
		subrno:integer		{number of subr descriptor}
	       );
      pointer :(eltype:sp);		{type of pointed object}
      power   :(elset:sp);		{type of set elements}
      files   :(filtype:sp);		{type of file elements}
      arrays,carray:
	       (aeltype:sp;		{type of array elements}
		inxtype:sp;		{type of array index}
		arpos:position		{position of array descriptor}
	       );
      records :(fstfld:ip;		{points to first field}
		tagsp:sp		{points to tag if present}
	       );
      variant :(varval:integer;		{tag value for this variant}
		nxtvar:sp;		{next equilevel variant}
		subtsp:sp		{points to tag for sub-case}
	       );
      tag     :(fstvar:sp;		{first variant of case}
		tfldsp:sp		{type of tag}
	       )
  end;

  identifier=record
    idtype:sp;				{type of identifier}
    name:alpha;				{name of identifier}
    llink,rlink:ip;			{see enterid,searchid}
    next:ip;				{used to make several chains}
    iflag:iflagset;			{several flag bits}
    case klass:idclass of
      types    :();
      konst   :(value:integer);		{for integers the value is
		  computed and stored in this field.
		  For strings and reals an assembler constant is
		  defined labeled '.1', '.2', ...  This '.' number is then
		  stored in value. For reals value may be negated to
		  indicate that the opposite of the assembler constant
		  is needed. }
      vars    :(vpos:position);		{position of var}
      field   :(foffset:integer);	{offset to begin of record}
      carrbnd :();			{idtype points to carray struct}
      proc,func:
	(case pfkind:kindofpf of
	   standard:(key:standpf);	{identification}
	   formal,actual,forwrd,extrn:
	     (pfpos:position;		{lv gives declaration level.
			sg gives instruction segment of this proc and
			ad is relevant for formal pf's and for
			functions (no conflict!!).
			for functions: ad is the result address.
			for formal pf's: ad is the address of the
			descriptor }
	      pfno:integer;		{unique pf number}
	      parhead:ip;		{head of parameter list}
	      headlc:integer		{lc when heading scanned}
	     )
	)
  end;

  labl=record
    nextlp:lp;		{chain of labels}
    seen:boolean;
    labval:integer;	{label number given by the programmer}
    labname:integer;	{label number given by the compiler}
    labdlb:integer	{zero means only locally used,
			  otherwise dlbno of label information}
  end;

{-------------------------------------------------------------------}
var  {the most frequent used externals are declared first}
  sy:symbol;		{last symbol}
  a:attr;		{type,access method,position,value of expr}
{returned by insym}
  ch:char;		{last character}
  chsy:chartype;	{type of ch, used by insym}
  val:integer;		{if last symbol is an constant }
  ix:integer;		{string length}
  eol:boolean;		{true of current ch is a space, replacing a newline}
  zerostring:boolean;	{true for strings in " "}
  id:alpha;		{if last symbol is an identifier}
{some counters}
  lino:integer;		{line number on code file (1..n) }
  dlbno:integer;	{number of last global number}
  lcmax:integer;	{keeps track of maximum of lc}
  level:integer;	{current static level}
  ptrsize:integer;
  realsize:integer;
  fhsize:integer;	{file header size}
  argc:integer;		{index in argv}
  lastpfno:integer;	{unique pf number counter}
  copt:integer;		{C-type strings allowed if on}
  dopt:integer;		{longs allowed if on}
  iopt:integer;		{number of bits in sets with base integer}
  sopt:integer; 	{standard option}
{pointers pointing to standard types}
  realptr,intptr,textptr,emptyset,boolptr:sp;
  charptr,nilptr,stringptr,longptr:sp;
{flags}
  giveline:boolean;	{give source line number at next statement}
  including:boolean;	{no LIN's for included code}
  eofexpected:boolean;	{quit without error if true (nextch) }
  main:boolean;		{complete programme or a module}
  intypedec:boolean;	{true if nested in typedefinition}
  fltused:boolean;	{true if floating point instructions are used}
  seconddot:boolean;	{indicates the second dot of '..'}
{pointers}
  fwptr:ip;		{head of chain of forward reference pointers}
  progp:ip;		{program identifier}
  currproc:ip;		{current procedure/function ip (see casestatement)}
  top:np;		{pointer to the most recent name space}
  lastnp:np;		{pointer to nameinfo of last searched ident }
{records}
  b:blockinfo;		{all info to be stacked at pfdeclaration}
  e:errec;		{all info required for error messages}
  fa:attr;		{attr for current file name}
{arrays}
  source:fntype;	{name of pascal source file}
  strbuf:array[1..smax] of char;
  iop:array[boolean] of ip;
			{false:standard input, true:standard output}
  rw:array[rwrange] of alpha;
			{reserved words}
  frw:array[0..idmax] of integer;
			{indices in rw}
  rsy:array[rwrange] of symbol;
			{symbol for reserved words}
  cs:array[char] of chartype;
			{chartype of a character}
  csy:array[rparentch..equal] of symbol;
			{symbol for single character symbols}
  lmn:array[libmnem] of packed array[1..4] of char;
			{mnemonics of pascal library routines}
  opt:array['a'..'z'] of integer;
  forceopt:array['a'..'z'] of boolean;
			{26 different options}
  undefip:array[idclass] of ip;
			{used in searchid}
  argv:array[0..maxargc] of
	 record name:alpha; ad:integer end;
			{save here the external heading names}
{files}
  em1:file of byte;	{the EM1 code}
  errors:file of errec;
			{the compilation errors}
{===================================================================}

procedure gen2bytes(b:byte; i:integer);
var b1,b2:byte;
begin
  if i<0 then
    if i<minint then begin b1:=0; b2:=t7 end
    else begin i:=-i-1; b1:=t8m1 - i mod t8; b2:=t8m1 - i div t8 end
  else begin b1:=i mod t8; b2:=i div t8 end;
  write(em1,b,b1,b2)
end;

procedure gencst(i:integer);
begin
  if (i>=0) and (i<sp_ncst0) then write(em1,i+sp_fcst0)
  else gen2bytes(sp_cst2,i)
end;

procedure genclb(i:integer);
begin if i<t8 then write(em1,sp_ilb1,i) else gen2bytes(sp_ilb2,i) end;

procedure genilb(i:integer);
begin lino:=lino+1;
  if i<sp_nilb0 then write(em1,i+sp_filb0) else genclb(i);
end;

procedure gendlb(i:integer);
begin if i<t8 then write(em1,sp_dlb1,i) else gen2bytes(sp_dlb2,i) end;

procedure gen0(b:byte);
begin write(em1,b); lino:=lino+1 end;

procedure gen1(b:byte; i:integer);
begin gen0(b); gencst(i) end;

procedure gend(b:byte; d:integer);
begin gen0(b); gendlb(d) end;

procedure genident(nametype:byte; var a:alpha);
var i,j:integer;
begin i:=idmax;
  while (a[i]=' ') and (i>1) do i:=i-1;
  write(em1,nametype,i);
  for j:=1 to i do write(em1,ord(a[j]))
end;

procedure gensp(m:libmnem);
var i:integer;
begin gen0(op_cal); write(em1,sp_pnam,4);
  for i:=1 to 4 do write(em1,ord(lmn[m][i]))
end;

procedure genpnam(b:byte; fip:ip);
var n:alpha; i,j:integer;
begin
  if fip^.pfpos.lv<=1 then n:=fip^.name else
    begin n:='_       '; j:=1; i:=fip^.pfno;
      while i<>0 do
	begin j:=j+1; n[j]:=chr(i mod 10 + ord('0')); i:=i div 10 end;
    end;
  gen0(b); genident(sp_pnam,n)
end;

procedure genend;
begin write(em1,sp_cend) end;

procedure genlin;
begin giveline:=false;
  if opt['l']<>off then if main then gen1(op_lin,e.orig)
end;

procedure genreg(ad,sz,nr:integer);
begin
  if sz<=wordsize then
    begin gen1(ps_mes,mesreg); gencst(ad); gencst(nr); genend end
end;

{===================================================================}

procedure puterr(err:integer);
{as you will notice, all error numbers are preceded by '+' and '0' to
  ease their renumbering in case of new errornumbers.
}
begin e.erno:=err; write(errors,e);
  if err>0 then begin gen1(ps_mes,meserror); genend end
end;

procedure error(err:integer);
begin e.mess:=spaces; e.mesi:= -1; puterr(err) end;

procedure errid(err:integer; var id:alpha);
begin e.mess:=id; e.mesi:= -1; puterr(err) end;

procedure errint(err:integer; i:integer);
begin e.mesi:=i; e.mess:=spaces; puterr(err) end;

procedure asperr(err:integer);
begin if a.asp<>nil then begin error(err); a.asp:=nil end end;

procedure teststandard;
begin if sopt<>off then error(-(+01)) end;

procedure enterid(fip: ip);
{enter id pointed at by fip into the name-table,
  which on each declaration level is organised as
  an unbalanced binary tree}
var nam:alpha; lip,lip1:ip; lleft,again:boolean;
begin nam:=fip^.name; again:=false;
  lip:=top^.fname;
  if lip=nil then top^.fname:=fip else
    begin
      repeat lip1:=lip;
	if lip^.name>nam then
	  begin lip:=lip^.llink; lleft:=true end
	else
	  begin if lip^.name=nam then again:=true;  {name conflict}
	    lip:=lip^.rlink; lleft:=false;
	  end;
      until lip=nil;
      if lleft then lip1^.llink:=fip else lip1^.rlink:=fip
    end;
  fip^.llink:=nil; fip^.rlink:=nil;
  if again then errid(+02,nam);
end;

procedure initpos(var p:position);
begin p.lv:=level; p.ad:=0;
#ifdef SEGMENTS
  p.sg:=0
#endif
end;

procedure inita(fsp:sp; fad:integer);
begin with a do begin
  asp:=fsp; packbit:=false; ak:=fixed; pos.ad:=fad; pos.lv:=level;
#ifdef SEGMENTS
  pos.sg:=0;
#endif
end end;

function newip(kl:idclass; n:alpha; idt:sp; nxt:ip):ip;
var p:ip; f:iflagset;
begin f:=[];
  case kl of
    types,carrbnd:  {similar structure}
      new(p,types);
    konst:
      begin new(p,konst); p^.value:=0 end;
    vars:
      begin new(p,vars); f:=[used,assigned]; initpos(p^.vpos) end;
    field:
      begin new(p,field); p^.foffset:=0 end;
    proc,func:  {same structure}
      begin new(p,proc,actual); p^.pfkind:=actual;
	initpos(p^.pfpos); p^.pfno:=0; p^.parhead:=nil; p^.headlc:=0
      end
  end;
  p^.name:=n; p^.klass:=kl; p^.idtype:=idt; p^.next:=nxt;
  p^.llink:=nil; p^.rlink:=nil; p^.iflag:=f; newip:=p
end;

function newsp(sf:structform; sz:integer):sp;
var p:sp; sflag:sflagset;
begin sflag:=[];
  case sf of
    scalar:
      begin new(p,scalar); p^.scalno:=0; p^.fconst:=nil end;
    subrange:
      new(p,subrange);
    pointer:
      begin new(p,pointer); p^.eltype:=nil end;
    power:
      new(p,power);
    files:
      begin new(p,files); sflag:=[withfile] end;
    arrays,carray:  {same structure}
      new(p,arrays);
    records:
      new(p,records);
    variant:
      new(p,variant);
    tag:
      new(p,tag);
  end;
  p^.form:=sf; p^.size:=sz; p^.sflag:=sflag; newsp:=p;
end;

procedure init1;
var c:char;
begin
{initialize the first name space}
  new(top,blck); top^.occur:=blck; top^.nlink:=nil; top^.fname:=nil;
  level:=0;
{reserved words}
  rw[ 0]:='if      ';	rw[ 1]:='do      ';	rw[ 2]:='of      ';
  rw[ 3]:='to      ';	rw[ 4]:='in      ';	rw[ 5]:='or      ';
  rw[ 6]:='end     ';	rw[ 7]:='for     ';	rw[ 8]:='nil     ';
  rw[ 9]:='var     ';	rw[10]:='div     ';	rw[11]:='mod     ';
  rw[12]:='set     ';	rw[13]:='and     ';	rw[14]:='not     ';
  rw[15]:='then    ';	rw[16]:='else    ';	rw[17]:='with    ';
  rw[18]:='case    ';	rw[19]:='type    ';	rw[20]:='goto    ';
  rw[21]:='file    ';	rw[22]:='begin   ';	rw[23]:='until   ';
  rw[24]:='while   ';	rw[25]:='array   ';	rw[26]:='const   ';
  rw[27]:='label   ';	rw[28]:='repeat  ';	rw[29]:='record  ';
  rw[30]:='downto  ';	rw[31]:='packed  ';	rw[32]:='program ';
  rw[33]:='function';	rw[34]:='procedur';
{corresponding symbols}
  rsy[ 0]:=ifsy;	rsy[ 1]:=dosy;		rsy[ 2]:=ofsy;
  rsy[ 3]:=tosy;	rsy[ 4]:=insy;		rsy[ 5]:=orsy;
  rsy[ 6]:=endsy;	rsy[ 7]:=forsy;		rsy[ 8]:=nilcst;
  rsy[ 9]:=varsy;	rsy[10]:=divsy;		rsy[11]:=modsy;
  rsy[12]:=setsy;	rsy[13]:=andsy;		rsy[14]:=notsy;
  rsy[15]:=thensy;	rsy[16]:=elsesy;	rsy[17]:=withsy;
  rsy[18]:=casesy;	rsy[19]:=typesy;	rsy[20]:=gotosy;
  rsy[21]:=filesy;	rsy[22]:=beginsy;	rsy[23]:=untilsy;
  rsy[24]:=whilesy;	rsy[25]:=arraysy;	rsy[26]:=constsy;
  rsy[27]:=labelsy;	rsy[28]:=repeatsy;	rsy[29]:=recordsy;
  rsy[30]:=downtosy;	rsy[31]:=packedsy;	rsy[32]:=progsy;
  rsy[33]:=funcsy;	rsy[34]:=procsy;
{indices into rw to find reserved words fast}
  frw[0]:= 0; frw[1]:= 0; frw[2]:= 6; frw[3]:=15; frw[4]:=22;
  frw[5]:=28; frw[6]:=32; frw[7]:=33; frw[8]:=35;
{char types}
  for c:=chr(0) to chr(maxcharord) do cs[c]:=others;
  for c:='0' to '9' do cs[c]:=digit;
  for c:='A' to 'Z' do cs[c]:=upper;
  for c:='a' to 'z' do cs[c]:=lower;
  cs[chr(newline)]:=layout;
  cs[chr(hortab)]:=layout;
  cs[chr(formfeed)]:=layout;
  cs[chr(carret)]:=layout;
{characters with corresponding chartype in ASCII order}
  cs[chr(tab)]:=tabch;
  cs[' ']:=layout;	cs['"']:=dquotech;	cs['''']:=quotech;
  cs['(']:=lparentch;	cs[')']:=rparentch;	cs['*']:=star;
  cs['+']:=plusch;	cs[',']:=commach;	cs['-']:=minch;
  cs['.']:=periodch;	cs['/']:=slash;		cs[':']:=colonch;
  cs[';']:=semich;	cs['<']:=lessch;	cs['=']:=equal;
  cs['>']:=greaterch;	cs['[']:=lbrackch;	cs[']']:=rbrackch;
  cs['^']:=arrowch;	cs['{']:=lbracech;
{single character symbols in chartype order}
  csy[rparentch]:=rparent;	csy[lbrackch]:=lbrack;
  csy[rbrackch]:=rbrack;	csy[commach]:=comma;
  csy[semich]:=semicolon;	csy[arrowch]:=arrow;
  csy[plusch]:=plussy;		csy[minch]:=minsy;
  csy[slash]:=slashsy;		csy[star]:=starsy;
  csy[equal]:=eqsy;
end;

procedure init2;
var p,q:ip; k:idclass;
begin
{undefined identifier pointers used by searchid}
  for k:=types to func do
    undefip[k]:=newip(k,spaces,nil,nil);
{standard type pointers. some size are filled in by handleopts}
  intptr   :=newsp(scalar,intsize);
  realptr  :=newsp(scalar,0);
  longptr  :=newsp(scalar,longsize);
  charptr  :=newsp(scalar,charsize);
  boolptr  :=newsp(scalar,boolsize);
  nilptr   :=newsp(pointer,0);
  stringptr:=newsp(pointer,0);
  emptyset :=newsp(power,intsize); emptyset^.elset:=nil;
  textptr  :=newsp(files,0); textptr^.filtype:=charptr;
{standard type names}
  enterid(newip(types,'integer ',intptr,nil));
  enterid(newip(types,'real    ',realptr,nil));
  enterid(newip(types,'char    ',charptr,nil));
  enterid(newip(types,'boolean ',boolptr,nil));
  enterid(newip(types,'text    ',textptr,nil));
{standard constant names}
  q:=nil; p:=newip(konst,'false   ',boolptr,q); enterid(p);
  q:=p; p:=newip(konst,'true    ',boolptr,q); p^.value:=1; enterid(p);
  boolptr^.fconst:=p;
  p:=newip(konst,'maxint  ',intptr,nil); p^.value:=maxint; enterid(p);
  p:=newip(konst,spaces,charptr,nil); p^.value:=maxcharord;
  charptr^.fconst:=p;
end;

procedure init3;
var j:standpf; p:ip; q:np;
    pfn:array[standpf] of alpha;
    ftype:array[feof..farctan] of sp;
begin
{names of standard procedures/functions}
  pfn[pread	]:='read    ';	pfn[preadln	]:='readln  ';
  pfn[pwrite	]:='write   ';	pfn[pwriteln	]:='writeln ';
  pfn[pput	]:='put     ';	pfn[pget	]:='get     ';
  pfn[ppage	]:='page    ';	pfn[preset	]:='reset   ';
  pfn[prewrite	]:='rewrite ';	pfn[pnew	]:='new     ';
  pfn[pdispose	]:='dispose ';	pfn[ppack	]:='pack    ';
  pfn[punpack	]:='unpack  ';	pfn[pmark	]:='mark    ';
  pfn[prelease	]:='release ';	pfn[phalt	]:='halt    ';
  pfn[feof	]:='eof     ';	pfn[feoln	]:='eoln    ';
  pfn[fabs	]:='abs     ';	pfn[fsqr	]:='sqr     ';
  pfn[ford	]:='ord     ';	pfn[fchr	]:='chr     ';
  pfn[fpred	]:='pred    ';	pfn[fsucc	]:='succ    ';
  pfn[fodd	]:='odd     ';	pfn[ftrunc	]:='trunc   ';
  pfn[fround	]:='round   ';	pfn[fsin	]:='sin     ';
  pfn[fcos	]:='cos     ';	pfn[fexp	]:='exp     ';
  pfn[fsqrt	]:='sqrt    ';	pfn[fln		]:='ln      ';
  pfn[farctan	]:='arctan  ';
{parameter types of standard functions}
  ftype[feof	]:=nil;		ftype[feoln	]:=nil;
  ftype[fabs	]:=nil;		ftype[fsqr	]:=nil;
  ftype[ford	]:=nil;		ftype[fchr	]:=intptr;
  ftype[fpred	]:=nil;		ftype[fsucc	]:=nil;
  ftype[fodd	]:=intptr;	ftype[ftrunc	]:=nil;
  ftype[fround	]:=nil;		ftype[fsin	]:=realptr;
  ftype[fcos	]:=realptr;	ftype[fexp	]:=realptr;
  ftype[fsqrt	]:=realptr;	ftype[fln	]:=realptr;
  ftype[farctan	]:=realptr;	
{standard procedure/function identifiers}
  for j:=pread to phalt do
    begin new(p,proc,standard); p^.klass:=proc;
      p^.name:=pfn[j]; p^.pfkind:=standard; p^.key:=j; enterid(p);
    end;
  for j:=feof to farctan do
    begin new(p,func,standard); p^.klass:=func; p^.idtype:=ftype[j];
      {idtype is used not for result type but for parameter type !! }
      p^.name:=pfn[j]; p^.pfkind:=standard; p^.key:=j; enterid(p);
    end;
{program identifier}
  progp:=newip(proc,'_main   ',nil,nil);
{new name space for user externals}
  new(q,blck); q^.occur:=blck; q^.nlink:=top; q^.fname:=nil; top:=q;
end;

procedure init4;
var c:char;
begin
{pascal library mnemonics}
  lmn[ELN ]:='_eln';	lmn[EFL ]:='_efl';	lmn[CLS ]:='_cls';
  lmn[WDW ]:='_wdw';
  lmn[OPN ]:='_opn';	lmn[GETX]:='_get';	lmn[RDI ]:='_rdi';
  lmn[RDC ]:='_rdc';	lmn[RDR ]:='_rdr';	lmn[RDL ]:='_rdl';
  lmn[RLN ]:='_rln';
  lmn[CRE ]:='_cre';	lmn[PUTX]:='_put';	lmn[WRI ]:='_wri';
  lmn[WSI ]:='_wsi';	lmn[WRC ]:='_wrc';	lmn[WSC ]:='_wsc';
  lmn[WRS ]:='_wrs';	lmn[WSS ]:='_wss';	lmn[WRB ]:='_wrb';
  lmn[WSB ]:='_wsb';	lmn[WRR ]:='_wrr';	lmn[WSR ]:='_wsr';
  lmn[WRL ]:='_wrl';	lmn[WSL ]:='_wsl';
  lmn[WRF ]:='_wrf';	lmn[WRZ ]:='_wrz';	lmn[WSZ ]:='_wsz';
  lmn[WLN ]:='_wln';	lmn[PAG ]:='_pag';
  lmn[ABR ]:='_abr';	lmn[RND ]:='_rnd';	lmn[SIN ]:='_sin';
  lmn[COS ]:='_cos';	lmn[EXPX]:='_exp';	lmn[SQT ]:='_sqt';
  lmn[LOG ]:='_log';	lmn[ATN ]:='_atn';	lmn[ABI ]:='_abi';
  lmn[ABL ]:='_abl';
  lmn[BCP ]:='_bcp';	lmn[BTS ]:='_bts';	lmn[NEWX]:='_new';
  lmn[SAV ]:='_sav';	lmn[RST ]:='_rst';	lmn[INI ]:='_ini';
  lmn[HLT ]:='_hlt';	lmn[ASS ]:='_ass';	lmn[GTO ]:='_gto';
  lmn[PAC ]:='_pac';	lmn[UNP ]:='_unp';	lmn[DIS ]:='_dis';
  lmn[ASZ ]:='_asz';	lmn[MDI ]:='_mdi';	lmn[MDL ]:='_mdl';
{options}
  for c:='a' to 'z' do begin opt[c]:=0; forceopt[c]:=false end;
  opt['a']:=on;
  opt['f']:=floatsize div wordsize;	{default real size in words}
  opt['i']:=maxsetint+1;
  opt['l']:=on;
  opt['o']:=on;
  opt['p']:=addrsize div wordsize;	{default pointer size in words}
  opt['r']:=on;
  sopt:=off;
{scalar variables}
  b.nextbp:=nil;
  b.lc:=0;
  b.ilbno:=0;
  b.forwcount:=0;
  b.lchain:=nil;
  e.chno:=0;
  e.lino:=1;
  e.linr:=1;
  e.orig:=1;
  e.fnam:=emptyfnam;
  source:=emptyfnam;
  lino:=0;
  dlbno:=0;
  argc:=1;
  lastpfno:=0;
  giveline:=true;
  including:=false;
  eofexpected:=false;
  intypedec:=false;
  fltused:=false;
  seconddot:=false;
  iop[false]:=nil;
  iop[true]:=nil;
  argv[0].ad:=-1;
  argv[1].ad:=-1;
end;

procedure handleopts;
begin
  copt:=opt['c'];
  dopt:=opt['d'];
  iopt:=opt['i'];
  sopt:=opt['s'];
  realsize:=opt['f'] * wordsize; realptr^.size:=realsize;
  ptrsize:=opt['p'] * wordsize; nilptr^.size:=ptrsize;
  fhsize:=6*intsize + 2*ptrsize;
  textptr^.size:=fhsize+buffsize; stringptr^.size:=ptrsize;
  if sopt<>off then begin copt:=off; dopt:=off end
  else if opt['u']<>off then cs['_']:=lower;
  if copt<>off then enterid(newip(types,'string  ',stringptr,nil));
  if dopt<>off then enterid(newip(types,'long    ',longptr,nil));
  if opt['o']=off then begin gen1(ps_mes,mesoptoff); genend end;
  if ptrsize<>wordsize then begin gen1(ps_mes,mesvirtual); genend end;
  if dopt<>off then fltused:=true;  {temporary kludge}
end;

{===================================================================}

procedure trace(tname:alpha; fip:ip; var namdlb:integer);
var i:integer;
begin
  if opt['t']<>off then
    begin
      if namdlb=0 then
	begin dlbno:=dlbno+1; namdlb:=dlbno; gendlb(dlbno);
	  gen0(ps_rom); write(em1,sp_scon,8);
	  for i:=1 to 8 do write(em1,ord(fip^.name[i])); genend;
	end;
      gen1(op_mrk,0); gend(op_lae,namdlb); gen0(op_cal); genident(sp_pnam,tname);
    end;
end;

function formof(fsp:sp; forms:formset):boolean;
begin if fsp=nil then formof:=false else formof:=fsp^.form in forms end;

function sizeof(fsp:sp):integer;
var s:integer;
begin s:=0;
  if fsp<>nil then s:=fsp^.size;
  if s<>1 then if odd(s) then s:=s+1;
  sizeof:=s
end;

function even(i:integer):integer;
begin if odd(i) then i:=i+1; even:=i end;

procedure exchange(l1,l2:integer);
var d1,d2:integer;
begin d1:=l2-l1; d2:=lino-l2;
  if (d1<>0) and (d2<>0) then
    begin gen1(ps_exc,d1); gencst(d2) end
end;

procedure setop(m:byte);
begin gen1(m,even(sizeof(a.asp))) end;

procedure expandemptyset(fsp:sp);
var i:integer;
begin for i:=2 to sizeof(fsp) div wordsize do gen1(op_loc,0); a.asp:=fsp end;

procedure push(local:boolean; ad:integer; sz:integer);
begin assert not odd(sz);
  if sz>wordsize then
    begin if local then gen1(op_lal,ad) else gen1(op_lae,ad);
      gen1(op_loi,sz)
    end
  else
    if local then gen1(op_lol,ad) else gen1(op_loe,ad)
end;

procedure pop(local:boolean; ad:integer; sz:integer);
begin assert not odd(sz);
  if sz>wordsize then
    begin if local then gen1(op_lal,ad) else gen1(op_lae,ad);
      gen1(op_sti,sz)
    end
  else
    if local then gen1(op_stl,ad) else gen1(op_ste,ad)
end;

procedure lexical(m:byte; lv:integer; ad:integer; sz:integer);
begin gen1(op_lex,level-lv); gen1(op_adi,ad); gen1(m,sz) end;

procedure loadpos(var p:position; sz:integer);
begin with p do
  if lv<=0 then
#ifdef SEGMENTS
    if sg<>0 then
      begin gen1(op_lsa,sg); gen1(op_adi,ad); gen1(op_loi,sz) end
    else
#endif
      push(global,ad,sz)
  else
    if lv=level then push(local,ad,sz) else
      lexical(op_loi,lv,ad,sz);
end;

procedure descraddr(var p:position);
begin if p.lv=0 then gend(op_lae,p.ad) else loadpos(p,ptrsize) end;

procedure loadaddr;
begin with a do begin
  case ak of
    fixed:
      with pos do
	if lv<=0 then
#ifdef SEGMENTS
	  if sg<>0 then
	    begin gen1(op_lsa,sg); gen1(op_adi,ad) end
	  else
#endif
	    gen1(op_lae,ad)
	else
	  if lv=level then gen1(op_lal,ad) else
	    begin gen1(op_lex,level-lv); gen1(op_adi,ad) end;
    pfixed:
      loadpos(pos,ptrsize);
    ploaded:
      ;
    indexed:
      gen0(op_aas);
  end;  {case}
  ak:=ploaded;
end end;

procedure load;
var sz:integer;
begin with a do begin
  sz:=sizeof(asp); if not packbit then sz:=even(sz);
  if asp<>nil then
    case ak of
      cst:
	gen1(op_loc,pos.ad);  {only one-word scalars}
      fixed:
	loadpos(pos,sz);
      pfixed:
	begin loadpos(pos,ptrsize); gen1(op_loi,sz) end;
      loaded:
	;
      ploaded:
	gen1(op_loi,sz);
      indexed:
	gen0(op_las);
    end;  {case}
  ak:=loaded;
end end;

procedure store;
var sz:integer;
begin with a do begin
  sz:=sizeof(asp); if not packbit then sz:=even(sz);
  if asp<>nil then
    case ak of
      fixed:
	with pos do
	  if lv<=0 then
#ifdef SEGMENTS
	    if sg<>0 then
	      begin gen1(op_lsa,sg); gen1(op_adi,ad); gen1(op_sti,sz) end
	    else
#endif
	      pop(global,ad,sz)
	  else
	    if level=lv then pop(local,ad,sz) else
	      lexical(op_sti,lv,ad,sz);
      pfixed:
	begin loadpos(pos,ptrsize); gen1(op_sti,sz) end;
      ploaded:
	gen1(op_sti,sz);
      indexed:
	gen0(op_sas);
    end;  {case}
end end;

procedure fieldaddr(off:integer);
begin with a do
  if (ak=fixed) and not packbit then pos.ad:=pos.ad+off else
    begin loadaddr; gen1(op_adi,off) end
end;

procedure loadcheap;
begin if formof(a.asp,[arrays..records]) then loadaddr else load end;

{===================================================================}

procedure nextch;
begin
  eol:=eoln(input); read(input,ch); e.chno:=e.chno+1; chsy:=cs[ch];
end;

procedure nextln;
begin
  if eof(input) then
    begin
      if not eofexpected then error(+03) else
	begin
	  if fltused then begin gen1(ps_mes,mesfloats); genend end;
	  gen0(ps_eof)
	end;
#ifdef STANDARD
      goto 9999
#endif
#ifndef STANDARD
      halt
#endif
    end;
  e.chno:=0; e.lino:=e.lino+1; e.linr:=e.linr+1;
  if not including then
    begin e.orig:=e.orig+1; giveline:=true end;
end;

procedure options(normal:boolean);
var c,ci:char; i:integer;

procedure getc;
var b:byte;
begin
  if normal then
    begin nextch; c:=ch end
  else
    begin read(em1,b); c:=chr(b) end
end;

begin
  repeat getc;
    if (c>='a') and (c<='z') then
      begin ci:=c; getc; i:=0;
	if c='+' then begin i:=1; getc end else
	if c='-' then getc else
	if cs[c]=digit then
	  repeat i:=i*10 + ord(c) - ord('0'); getc;
	  until cs