/*
 *	to do certain things with ttys
 */ 

#include	<sys/param.h>
#include	<sys/tty.h>

char buf[10];
char terminal[5+14+1];

char usage[] = "Usage: watch [quit-char] terminal\n";

main(ac, av)
int ac;
char *av[];
{
	register char *p;
	register char quit;
	register f;

	ac--;
	av++;
	if (ac > 1)
	{
		quit = **av;
		ac--;
		av++;
	}
	else
		quit = '\021';	/* control-q default*/
	if (ac != 1)
	{
		printf(usage);
		return(1);
	}
	p = terminal;
	strcpy(p, "/dev/");
	strncat(p, *av, 14);
	if ((f = open(p, 2)) == -1)
	{
		perror(p);
		return(1);
	}

	for(;;)
	{
		printf("quit char ");
		if (quit < '\040')
			printf("^%c\n", quit + 0100);
		else
			printf("%c\n", quit);
		printf("grab, view, share, or connect ? ");
		if (read(0, buf, sizeof buf) == 0)
			break;
		switch(buf[0])
		{
	    case 'g':
			if (ttyconnect(2, f, TCONGRAB, quit) < 0)
				perror(p);
			continue;
	    case 'v':
			if (fork() != 0)
				return(0);
			if (ttyconnect(2, f, TCONVIEW, quit) < 0)
				perror(p);
			break;
	    case 's':
			if (ttyconnect(2, f, TCONSHARE, quit) < 0)
				perror(p);
			continue;
	    case 'c':
			if (ttyconnect(2, f, TCONLOG, quit) < 0)
				perror(p);
			continue;
		}
		break;
	}

	printf("\nFinished.\n");
	return(0);
}
