#
/* mail command usage
 mail
 prints your mail
 mail people
 sends standard input to people
 */ 

#define	SIGINT	2
#define MAILDIR "/usr/mail"

struct passwd {
	char *pw_name;
	char *pw_passwd;
	int pw_uid;
	int pw_gid;
	char *pw_gecos;
	char *pw_dir;
	char *pw_shell;
} passwd;

struct {
	int junk[18];
} statb;

char lettmp[] "/tmp/maxxxxx";
char preptmp[] "/tmp/mbxxxxx";
char *my_name, buf[512];
char header[] "	From xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
int my_id, ptmp, ltmp;

main(argc, argv)
	char **argv;
{
	extern delexit();
	if(stat(MAILDIR, &statb) < 0) {
		writes(2, "can't find mail directory\n");
		exit();
	}
	myname();
	signal(SIGINT, delexit);
	tmpnames();
	close(creat(preptmp, 0600));
	ptmp = open(preptmp, 2);
	/*
	 | read user's mail.
	 */ 
	if(argc == 1 || argv[1][0] == '-')
		printmail(argc, argv);
	/*
	 | send mail.
	 */ 
	else
		sendmail(argc, argv);
	delexit();
}
printmail(argc, argv)
	char **argv;
{
	register mboxfd, mailfd;
	char c;
	mailfd = open(mailfile(my_name), 2);
	if(mailfd < 0 || read(mailfd, &c, 1) <= 0) {
		writes(2, "No mail\n");
		return;
	}
	copy(mailfd, 1);
	c = 'n';
	if(argc < 2) {
		if(ttyn(0) != 'x') {
			writes(2, "Save?");
			c = getchar();
		}
	}
	else
		c = argv[1][1];
	if(c != 'l')
		unlink(mailfile(my_name));
	if(c == 'y') {
		setuid(my_id);
		mboxfd = open("mbox", 2);
		if(mboxfd < 0 && (mboxfd = creat("mbox", 0644)) < 0)
			writes(2, "Can't create 'mbox'\nMail not saved\n");
		else {
			prepend(mailfd, mboxfd);
			writes(2, "Saved mail in 'mbox'\n");
		}
	}
	return;
}
sendmail(argc, argv)
	char **argv;
{
	extern fout;
	register c, deadfd, nosave;
	char *name;
	int n;
	prepheader();
	fcreat(lettmp, &fout);
	do {
		n = getline();
		if(buf[0] == '.' && buf[1] == '\n')
			break;
		putline();
	}
	while(buf[n-1] > 0);
	putchar('\n');
	flush();
	close(fout);
	ltmp = open(lettmp, 2);
	nosave = 1;
	while(--argc) {
		setpw();
		if(getname(name = *++argv))
			sendto(name);
		else {
			writes(2, "No such user: ");
			writes(2, name);
			writes(2, "\n");
			nosave = 0;
		}
	}
	if(nosave || ttyn(0) == 'x')
		return;
	setuid(my_id);
	unlink("dead.letter");
	if((deadfd = creat("dead.letter", 0644)) >= 0) {
		copy(ltmp, deadfd);
		writes(2, "Letter saved in 'dead.letter'\n");
	}
}
getline() {
	register char *p;
	*(p = buf) = getchar();
	while(*p > 0 && *p != '\n')
		*++p = getchar();
	return(p-buf+1);
}
putline() {
	register char *p;
	putchar(*(p = buf));
	while(*p > 0 && *p != '\n')
		putchar(*++p);
}
sendto(person)
	char *person;
{
	register fd;
	register char *fname;
	fname = mailfile(person);
	if((fd = open(fname, 2)) < 0)
		fd = creat(fname, 0600);
	seek(ptmp, 0, 0);
	copy(fd, ptmp);
	seek(fd, 0, 0);
	writes(fd, header);
	copy(ltmp, fd);
	copy(ptmp, fd);
	close(fd);
}
getname(name)
	char *name;
{
	register struct passwd *p;
	while(p = getpwent())
		if(equal(p->pw_name, name))
			return(1);
	return(0);
}
prepend(fd1, fd2) {
	seek(ptmp, 0, 0);
	copy(fd2, ptmp);
	seek(fd2, 0, 0);
	copy(fd1, fd2);
	copy(ptmp, fd2);
}
copy(fd1, fd2) {
	register n;
	seek(fd1, 0, 0);
	while((n = read(fd1, buf, 512)) > 0)
		write(fd2, buf, n);
}
setpw() {
	extern fin;
	static pwfil;
	if(pwfil == 0) {
		fopen("/etc/passwd", &fin);
		pwfil = fin;
	}
	else
		fin = pwfil;
	(&fin)[1] = 0;
	seek(fin, 0, 0);
}
getpwent() {
	register char *p;
	register c;
	static char line[100];
	p = line;
	while((c = getchar()) != '\n') {
		if(c <= 0)
			return(0);
		if(p < line+98)
			*p++ = c;
	}
	*p = 0;
	p = line;
	passwd.pw_name = p;
	p = pwskip(p);
	passwd.pw_passwd = p;
	p = pwskip(p);
	passwd.pw_uid = atoi(p);
	p = pwskip(p);
	passwd.pw_gid = atoi(p);
	p = pwskip(p);
	passwd.pw_gecos = p;
	p = pwskip(p);
	passwd.pw_dir = p;
	p = pwskip(p);
	passwd.pw_shell = p;
	return(&passwd);
}
pwskip(ap)
	char *ap;
{
	register char *p;
	p = ap;
	while(*p != ':') {
		if(*p == 0)
			return(p);
		p++;
	}
	*p++ = 0;
	return(p);
}
delexit() {
	unlink(lettmp);
	unlink(preptmp);
	exit();
}
tmpnames() {
	register i, pid;
	pid = getpid();
	for(i = 11; i >= 7; --i) {
		lettmp[i] = preptmp[i] = (pid&07)+'0';
		pid =>> 3;
	}
}
equal(string1, string2) {
	register char *s1, *s2;
	s1 = string1;
	s2 = string2;
	while(*s1++ == *s2)
		if(*s2++ == 0)
			return(1);
	return(0);
}
myname() {
	register me;
	register struct passwd *p;
	extern fin;
	my_id = me = getuid()&0377;
	setpw();
	while(p = getpwent())
		if(p->pw_uid == me) {
			my_name = passwd.pw_name;
			fin = (&fin)[1] = 0;
			return;
		}
	writes(2, "Who are you?\n");
	exit();
}
writes(fd, string)
	char *string;
{
	char *p;
	for(p = string; *p; p++)
		;
	write(fd, string, p-string);
}
prepheader() {
	int tbuf[2];
	register char *p, *q;
	p = header+6;
	q = my_name;
	while(*q)
		*p++ = *q++;
	*p++ = ' ';
	time(tbuf);
	q = ctime(tbuf);
	while(*p++ = *q++)
		;
}
mailfile(username)
	char *username;
{
	static char name[20];
	register char *p, *q;
	p = MAILDIR;
	q = name;
	while(*p)
		*q++ = *p++;
	*q++ = '/';
	p = username;
	while(*q++ = *p++)
		;
	return(name);
}
