c==========================================================================
c**************************************************************************
c
c                            waveform  estimation  program
c
c**************************************************************************
c==========================================================================
c
c	Modified from raul's program to solve for two filters (v and h)
c
c........ information about the input seismogram
c
	data ntr/30/,nt/1000/
	integer*2 igp(50),igm(50),ish(50)
c	integer*2 ibuf(1000)
	real buf(1000)
c	real u(1000),ti(1000),to(1000)
c
c........ parameters of the waveform estimation program
c	lc=length of the filters to be computed
c		ngp=length of the gated primaries
c		ngm=length of the gated multiples
c		n=total length of the vectors passed to pop
c		ngx=number of traces to jump in x
		nn=
c		nda=length of gated direct arrival
c		nmda=length of convolution of multiple and direct
c		ncph=length of convolution of cp and h
c		nmdav=length of convolution of mda and v
c
	data lc/20/,ngp/70/,ngm/139/,ngx/30/,nda/125/,nitr/1/
	real v(50),vbar(50),ep(288),em(288),dp(288),w(288),wgths(50)
	real h(50),hbar(50),da(125),mda(263),cph(158),mdav(282)
	real prm1(70),prm2(70),mul(139),cp(139),inp(189),out(189)
c	equivalence (inp,ti),(out,to)
c
	call setfil(9,'wrpp',512)
	call setfil(10,'wigp',512)
	call setfil(12,'wigm',512)
	call setfil(14,'wixsh',512)
	call setfil(15,'wh',512)
	call setfil(16,'wv',512)
c	call setfil(17,'whbar',512)
c	call setfil(18,'wvbar',512)
	call setfil(19,'wda',512)
c
c 	call setfil(20,'newsbar',512)
c	call setfil(30,'gates',512)
c	call setfil(40,'input',512)
c	call setfil(60,'output',512)
	call setfil(50,'t',512+64)
	define file 50 (30,400,u,next)
c
c	compute parameters
c
	n=ngm+lc
	nn=n+2*lc-1
	nmda=ngm+nda-1
	ncph=ngm+lc-1
	nmdav=nmda+lc-1
c...compute the weigthing function
c
c
	do 5 j=1,lc
5	w(j)=0.
	do 15 j=lc,n
15	w(j)=.5*(1.+cos(3.1416*(j-lc)/ngm))
c
c..compute the tapering function for the waveform
c..
	do 17 j=1,lc
17	wgths(j)=.5*(1.+cos(3.1416*j/lc))
c..
c	alpha=5./lc
c	ce=exp(-alpha)
c	do 10 j=1,lc
c10	w(j)=0.
c	w(lc+1)=1.
c	j1=lc+2
c	do 15 j=j1,n
c15	w(j)=ce*w(j-1)
c	do 19 j=1,lc
c19	wgths(j)=1.
c..
c..
c...... read input data
	read(10) igp
	read(12) igm
	read(14) ish
	read(19),(da(i),i=1,nda)
c	do 20 k=1,1
c20	read(18) sbar
c	Initialize waveforms and set up constraint
	do 20 k=1,lc
	v(k)=0.
	h(k)=0.
	vbar(k)=0.
20	hbar(j)=0.
	h(1)=1.
c
c	Set up the initial box
c
	do 27 j=1,12
	read(9) buf
	ip1=igp(j)-2
	do 25 k=1,ngp
25	prm2(k)=buf(k+ip1)
27	write(50'j) prm2
c
	ji=12+1
	jf=ntr+12
c
c	Main loop over x
c
	do 200 j=ji,jf
	js=j-12
	j2=mod(j,ngx)+1
	j1=j-ish(j)
	j1=max0(j1,1)
	j1=mod(j1,ngx)+1
c	read(5) ntp
	read(9) buf
	ip1=igp(j)-2
	im1=igm(j)-1
	do 30 k=1,ngp
c 	u(k+ip1)=buf(k+ip1)
   30 prm2(k)=buf(k+ip1)
	do 40 k=1,ngm
c 	u(k+im1)=buf(k+im1)
   40 mul(k)=-buf(k+im1)
	write(50'j2) prm2
	read(50'j1) prm1
	call conv(ngp,ngp,ngm,prm1,prm2,cp)
	call conv(ngm,nda,nmda,mul,da,mda)
c  	write(30) u
c
c	Loop to do iterative calculation of v and h
c
	do 500 itr=1,nitr
	call conv(ngm,lc,ncph,cp,h,cph)
	call wvf(js,lc,v,vbar,nn,ep,em,dp,w,ngm,mda,
     *		cph,n,inp,out)
	write(16)v
	type 1000, (v(i),i=1,lc)
1000	format(5f15.10)
	call conv(nmda,lc,nmdav,mad,v,mdav)
	call wvf(js,lc,h,hbar,nn,ep,em,dp,w,ngm,cp,
     *		mdav,n,inp,out)
	write(15)h
	type 1000, (h(i),1=1,lc)
500	continue
c
c	do 55 jws=1,lc
c	s(jws)=s(jws)*wgths(jws)
c55	sbar(jws)=sbar(jws)*wgths(jws)
c..
c
	type60,js,j1,j2
   60 format(' ',/,'   j=',i5,',   j1=',i5,',   j2=',i5)
  200 continue
	endfile 50
c
	type400
400	format('  the end')
	stop
	end
c
c
	subroutine wvf(kw,lc,s,sbar,nn,ep,em,dp,w,nio,rinp,rout,
     1n,inp,out)
	real s(lc),sbar(lc),rinp(nio),rout(nio)
	real ep(nn),em(nn),dp(nn),w(nn),inp(n),out(n)
c	real ti(nt),to(nt)
c
	do 5 j=1,n
	inp(j)=0.
5	out(j)=0.
	n1=n+1
c
	scale=0.
	do 40 j=1,nio
	jt=j+lc
	scale=scale+rinp(j)*rinp(j)*w(jt)
	out(jt)=rout(j)
40	inp(jt)=rinp(j)
	scale=scale*8.
	do 45 j=n1,nn
45	w(j)=scale
c	write(40) ti
c	write(60) to
	call pop(nn,n,inp,ep,em,out,dp,w,lc,sbar,s)
	do 60 j=1,lc
60	sbar(j)=((kw-1)*sbar(j)+s(j))/kw
	return
	end
c
c
	subroutine corr(m,l,b,d,ar)
	real b(m),d(m),ar(l)
c
	do 5 j=1,l
    5 ar(j)=0.
	do 10 i=1,m
	do 10 j=1,m
   10 ar(i+j-1)=ar(i+j-1)+b(i)*d(m-j+1)
	return
	end
c
c
	subroutine big(n,b,nd,data)
	real data(nd)
	b=0.
	i1=max0(1,n-3)
	i2=min0(nd,n+3)
	if(i1.eq.1) i2=nd
	do 30 id=i1,i2
	t=data(id)
	t=abs(t)
	if(t.le.b) go to 30
	b=t
	n=id
   30 continue
	return
	end
	subroutine conv(nx,nb,ny,x,b,y)
	real x(nx),b(nb),y(ny)
c
	do 5 j=1,ny
    5 y(j)=0.
	do 10 i=1,nx
	do 10 j=1,nb
   10 y(i+j-1)=y(i+j-1)+x(i)*b(j)
	return
	end
	function bigest(nt,x)
	real x(nt)
	b=0.
	do 10 j=1,nt
	a=abs(x(j))
   10 if(a.gt.b) b=a
	bigest=b
	return
	end
	subroutine pop(nn,n,x,ep,em,y,dp,w,lc,sbar,s)
c	inputs
	dimension x(n),y(n),w(nn),sbar(lc)
c	outputs
	dimension ep(nn),em(nn),dp(nn),s(lc)
c
c              n                         2   n+lc=nn             2
c	min   sum w(i)*(x convolve s - y)  +   sum  w(i)*(s-sbar)
c             i=1			      i=n+1
c
	n1=n+1
	do 10 i=1,n
	dp(i)=-y(i)
	ep(i)=x(i)
 10	em(i)=x(i)
	ep(n1)=1.
	em(n1)=1.
	do 20 i=1,lc
 20	dp(i+n)=-sbar(i)
	do 50 jp=1,lc
	if(jp.eq.1) go to 40
	ep(n+jp)=0.
	em(n-jp+2)=0.
	call dot(n1,ep(jp),ep(jp),w(jp),dpp)
	call dot(n1,em,em,w(jp),dmm)
	call dot(n1,ep(jp),em,w(jp),dpm)
	cp=dpm/dpp
	cm=dpm/dmm
	do 30 i=1,n1
	j=i+jp-1
	ept=ep(j)-em(i)*cm
	em(i)=em(i)-ep(j)*cp
 30	ep(j)=ept
 40	continue
	call dot(n1,dp(jp),em,w(jp),dde)
	call dot(n1,em,em,w(jp),dmm)
	cde=dde/dmm
	do 50 i=1,n1
	j=i+jp-1
 50	dp(j)=dp(j)-em(i)*cde
	do 60 i=1,lc
 60	s(i)=dp(n+i)+sbar(i)
	return
	end
	subroutine dot(n,x,y,w,ans)
	dimension x(n),y(n),w(n)
	ans=0.
	do 10 i=1,n
 10	ans=ans+w(i)*x(i)*y(i)
	return
	end
