	p=r5
	.globl	ENTER,EXIT,GV,G68,G69
	.text
	jmp	SETGV

/ Called from BCPL with

/	overlay(filename,lowaddr,highaddr)

/ The subfile "filename" is  loaded at "lowaddr". This is
/ checked to make sure that the  high load address does not exceed "highaddr".
/ The overlay is entered at "lowaddr" for initialisation.

/ The overlay system is initialised by calling

/	initovly(filename)

/ where the argument is the name of the library file containing the overlays.
/ "initovly" returns the largest overlay in the file. If the initialisation is
/ unsuccessful a negative value is returned.

	.bss
nonames:	.=.+2		/ no of individual files
names:		.=.+100		/ 8 byte names
offsets:	.=.+20		/ offsets within the library file
lengths:	.=.+20		/ length of each a.out file
buf:		.=.+40		/ header buffer
fd:		.=.+2		/ file descriptor
offset:		.=.+2		/ offset in file

	.text
mnames = 7			/ number of individual files
amn = 0				/ magic number in a.out file
atsize = 2			/ text size   "
adsize = 4			/ data size   "   
absize = 6			/ bss size    "
arn = 0				/ name in ar files
arsize = 16			/ size   "
parm1 = 6			/ BCPL parameter 1
parm2 = 10			/  "       "     2
parm3 = 12			/  "       "     3
arg1 = 16			/ BCPL argument 1
arg2 = 20			/  "       "    2
indir = 0

	.data
sk:	sys	seek
skoff:	0;0
rd:	sys	read
rdad:	0
rdln:	0
op:	sys	open
opad:	0;0
	.text

OVERLAY:
G69:	jsr	r1,ENTER
	s
	.data
s:	7
	<overlay\0>
	.text
	asl	parm1(p)	/ make byte addresses
	asl	parm2(p)		
	asl	parm3(p)		
	mov	nonames,r3
loop:	dec	r3
	jlt	nfail		/ name not in table?
	mov	$names,r1	/ address of each name
	mov	r3,r2
	asl	r2
	asl	r2
	asl	r2
	add	r2,r1		/ set address of r3 rd item
	mov	parm1(p),r2	/ address of file name = parm 1
	mov	(r2),r0		/ set length
	cmp	$10,r0		/ if length < 8 include null byte
	jlt	nfail		/ string too long
	jeq	1f		/ length maximum
	inc	r0
1:	inc	r2		/ step over length
	inc	r2
	jsr	pc,cmps		/ does it match?
	jes	loop		/ not found ?
	mov	parm3(p),r0	/ high address = parm 2
	sub	parm2(p),r0	/ start address = parm 3
	mov	r3,r2		/ convert to byte index
	asl	r2
	cmp	r0,lengths(r2)	/ will it fit into given space?
	jlt	ffail		/ wont fit ?
	mov	fd,r0
	mov	offsets(r2),skoff
	sys	indir;sk	/ find subfile within library file
	jcs	sfail		/ seek failed ?
	mov	fd,r0
	mov	parm2(p),rdad	/ load address = parm 2
	mov	lengths(r2),rdln	/ length of code
	sys	indir;rd	/ now read in overlay
	jcs	rfail
	jsr	pc,*parm2(p)	/ enter code at initialisation point
	jmp	EXIT

/ Note that the final library item must end with rts pc


nfail:	/ attempt to load name which does not exist
ffail:	/ file wont fit in space between lowaddr and highaddr
sfail:	/ seek failure within file
rfail:	/ read failure within file
	jsr	r0,*GV+4		/ call default error routine
	14

/ Compare strings with a length in r0.
/ r1 and r2 contain the string addresses. Error bit
/ set if the strings are not equal.
/ The parameter is always checked against the table entry
/ by including the null byte to terminate the string. This ensures
/ that "pass2" <> "pass2d" !
cmps:	
1:	dec	r0
	jlt	2f
	cmpb	(r1)+,(r2)+
	jeq	1b
	sec
	rts	pc
2:	clc
	rts	pc

/ Copy an 8 byte string.
/ r1 and r2 contain the source and destination string addresses.
cps:	mov	$4,r0
1:	dec	r0
	jlt	2f
	mov	(r1)+,(r2)+
	jmp	1b
2:	rts	pc


/ arg 1 is the name of a file in archive or library format

INITOVLY:	
G68:	jsr	r1,ENTER
	s1
	.data
s1:	10
	<initovly\0>
	.text
	mov	parm1(p),r1
	inc	r1		/ space over length word
	asl	r1		/ convert to byte address
	mov	r1,opad		/ set filename

	clr	r4		/ r4 will contain the largest
				/ overlay size so far
	sys	indir;op	/ open overlay file
	jes	ofail		/ open failed ?
	mov	r0,fd		/ remember file descriptor for
				/ subsequennt needs
	mov	$buf,rdad
	mov	$2,rdln
	sys	indir;rd	/ read magic number
	cmp	buf,$177555	/ check it is a library file
	jne	failm		/ no?
	clr	nonames
	mov	$2,offset	/ set current offset in file
again:
	cmp	$mnames,nonames		/ name table exceeded?
	jeq	efail
	mov	fd,r0
	mov	$buf,rdad
	mov	$40,rdln
	sys	indir;rd	/ read ar and a.out file headers
	tst	r0		/ EOF ?
	jeq	efail
	cmp	buf+20+amn,$407	/ test for a.out magic number
	jne	failm
	mov	nonames,r1
	asl	r1
	asl	r1
	asl	r1
	mov	$names,r2
	add	r1,r2
	mov	$buf,r1
	jsr	pc,cps		/ copy name from buffer
	mov	buf+20+atsize,r0/ get sizes from a.out header
	add	buf+20+adsize,r0
	add	buf+20+absize,r0/ text+data+bss size
	mov	nonames,r1
	asl	r1
	mov	r0,lengths(r1)	/ set length and offset
	mov	offset,offsets(r1)	/ for this segment
	add	$40,offsets(r1)		/ add in headers
	add	buf+arsize,offset/ update offset by length
	add	$20,offset	/ add in ar header size
	cmp	r4,r0		/ set r4 to largest subfiles to date
	jge	1f
	mov	r0,r4
1:	bit	buf+arsize,$1	/ round up offset to next
	jeq	1f		/ whole word
	inc	offset
1:	mov	offset,skoff
	mov	fd,r0
	sys	indir;sk		/ seek to next file
	inc	nonames
	jmp	again		/ and  look......

afail:	/ no arguments supplied to BCPL

ofail:	/ can't open overlay file

failm:	/ file is not a library file or a.out file

failf:	/ too many subfiles
	mov	$-1,r0
	br	end		/ error code


efail:	/ end of file reached
	mov	r4,r0		/ return size of largest overlay
	asr	r0		/ in words!
end:	jmp	EXIT

/ Initialisation code

SETGV:	mov	$OVERLAY,GV+138.
	mov	$INITOVLY,GV+136.





