/*
 *	Line Printer include file - define flags and
 *	structure of ioctl buffer.
 */

struct lpst
{
	struct lpdev	*lpaddr;	/* device register address */
	char		state;		/* internal state */
	char		bfree;		/* number of buffers unused */
	char		flag;		/* mode flags */
	short		icol;		/* input column */
	short		ocol;		/* output column */
	struct buf	*bfwd;		/* first buffer in chain */
	struct buf	*blst;		/* last buffer in chain */
	short		bc;		/* byte count */
	char		*ba;		/* next char in buffer */
};

/*
 * internal state of driver (byte only)
 */
#define	CLOSED	0	/* device closed */
#define	OPEN	1	/* device open for writing */
#define	CLOSING	2	/* user has called `close' */

/*
 * flags (byte only)
 */
#define	ASLP	0001		/* sleeping for buffers */
#define	POFF	0002		/* powered off - CDC only */
#define	ERR	0004		/* error bit set in status register */
#define	FLSH	0010		/* flush all buffers & return error */

/*
 * miscellaneous
 */
#define	PERFSKP	0375		/* skip to perforations */
#define	AUTEJ	0374		/* automatic perforation skip (lpd only) */
#define	NAUTEJ	0373		/* disable perforation skip (lpd only) */
#define	BMAX	4		/* maximum number of buffers used per device */

/*
 * ioctl commands
 */
#define	LPGET	0
#define	LPSET	1

struct lpiocb
{
	char	lp_state;
	char	lp_flag;
};
