(*$c+ *)
(*$i64   set size*)
program llama(input,output,comp);
(*$e+*)
(*$fl 10000*)
const
     maxset = 63;               (*maximum ordinal in set*)
     ordmaxchar = 127;          (*ordinal of max character*)
     uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
     lowercase = 'abcdefghijklmnopqrstuvwxyz';
     special   = '&=|.(, ';
     nspecial  = 7;
     prodlim     = 255 ;        (*maximum production number*)
     termlim     = maxset;      (*maximum terminal number*)
     nontermlim  = 127 ;         (*maximum number of non-terminals*)
     maxsym      = 190;         (*= termlim + nontermlim*)
     ntbase      = termlim ;    (*non-terminal offset for prdn. table*)
     linelength  = 120  ;
     statemax    = 511 ;        (*maximum state number*)
     hashmax     = 517 ;        (*maximum hash number*)
                                (*a prime number larger than statemax*)


     errormax = 63; (* required to be > 48 for 'pc' compiler! *)
     idlength = 20;
     nkeywords = 13;            (*number of keywords left,right,...*)
     tab = 2;
     TABCH = '	';
type
     shortint = -32767..32767;
     smallint = 0..255;  tagrange = 0..2;
     symrange = -1..maxsym;
     staterange = 0..statemax;
     termrange = 0..termlim;
    (* symbol returned by scan *)
      symbol = (nullsymb,
		lit,
		ident,
		number,
		equals,
		vbar,
		comma,
		dot,
		errsym,
		ampopen,
		ampersand,
		ampmark,
		left,
		right,
		non,
		prec,
		ampterm,
		ampgram,
		ampprog,
		amplabel,
		ampconst,
		amptype,
		ampvar,
		ampproc,
		ampmain,
		endfile
	      ) ;
     charclass = (letter,
		  digit,
		  vbarchar,
		  equalchar,
		  commachar,
		  dotchar,
		  lparenchar,
		  ampchar,
		  blankchar,
		  otherchar
		 );
    idname = packed array [1..idlength] of char;
   (* used for storing precedence and associativity *)
    levstruct = packed record
		  assoc : (leftass,rightass,nonass,nodef) ;
		  actionflag : boolean ;
		  lev : shortint
		end ;
   linearray = array[1..linelength] of char;  (*  output line  *)
    (* syntax errors for a line are stored in a linked list *)
    (* lookahead set *)
    setofterm = set of termrange ;
    ptmemory = ^memory ;
    ptitem = ^item ;
    item = record
	     dot : ptmemory ;
	     lookset : setofterm
	   end ;
    (* main data structure.
       contains internal representation of productions.
       contains pointers to items. *)
    memory = record
	       ptr : ptmemory;
	       case  tagrange of
	       0 : (contents : -prodlim..maxsym ) ;
	       1 : (itm : ptitem) ;
	       2 : (mempt : ptmemory)
	     end ;
    actiontype = (err,shift,reduce,accept) ;
    tconflict = (shred,redred) ;
    (* contains information about conflicts generated by grammar *)
    ptrconflict = ^rconflict ;
    rconflict = record
		    ctype : tconflict ;
		    cstate,
		    cterm,
		    resolved,
		    c1,
		    c2 : integer ;
		    lnk : ptrconflict
		  end ;
    (* entry in goto table *)
    ptgotorec = ^gotorec ;
    gotorec = record
		index: staterange;
		entry: staterange;
		gonext : ptgotorec
	      end ;
    (* entry in parsing action table *)
    ptparec = ^parec ;
    parec = record
	      index: termrange;
	      entry: shortint;
	      panext : ptparec
	    end ;
     errorrange = 0..errormax;
     pterrortype = ^errortype;
     errortype = record
		      errcol : 0..linelength;
		      errorno : errorrange;
		     next : pterrortype
		 end;
     symbolsettype = set of symbol;
var
   comp,
   action : text ;
   lineout : linearray ;
   col : 0..linelength ;
   (* data structures for handling error messages *)
   (* set of terminals *)
   termset: array[termrange] of idname;
   (* set of non-terminals *)
   ntermset : array[1..nontermlim] of idname ;
   nterms, nnonterms : integer ;
   token : idname ;
(* storage for productions and subsequently generated information *)
   releasepoint,freelist,memo,mem : ptmemory ;
   prodno : 1..prodlim ;
   prodptr: packed array [1..prodlim] of ptmemory;
   ntrdn: packed array [1..nontermlim] of ptmemory;
   empty: packed array [1..nontermlim] of boolean;
   level : array[1..prodlim] of levstruct;
   (* precedences of productions *)
   termlev : array[termrange] of levstruct;
   (* precedences of terminals *)
   initlev : levstruct ;
   ch : char ;
   numbval : integer ;
   pacount,gotocount : integer ;
    iterate,
    verbose: boolean;

   first : array[1..nontermlim] of setofterm;
   (* first terminal to which nonterminal can be reduced *)
  state: packed array [staterange] of ptmemory;
   (* points to head of each state *)
    statno : integer ;
    gotolist : array[1..nontermlim] of ptgotorec ; (*goto table *)
  palist: array [staterange] of ptparec; (* parsing action table *)
    listofconflicts : ptrconflict ;
   prodsum : array[1..prodlim,1..2] of smallint;
   (*  production summary *)
    gramrules : boolean ;
   maxright : integer;
   (* maximum no. of symbols found on rhs of production *)
     (* parsing action table optimisation information *)
    patab : array [staterange] of
	    record
	      nact : integer ;
	      otheract : boolean
	    end ;
    proderr : boolean ;
    (* debug flags *)
    pl : ptparec ;
   sequenced: boolean;
     errptr,tailptr : pterrortype;
     errorset : set of errorrange;
     seqno : integer;
     symb : symbol;
     currentlev : levstruct;
     k : symbol;
     usercode : boolean;
     dollarref: boolean;
     indent: integer;
     charmap: array [char] of charclass;
     keytable: array [0..nkeywords] of idname;
     keymap: array [0..nkeywords] of ampmark..ampmain;
     signpost: symbolsettype;
     llEND: termrange;
     llaccept,
     llerror,
     llstart: symrange;
     errorprodno: 1..prodlim;
     lineno: integer;
 
 
function ordptr(p: ptmemory): integer;
var
  fudge: record
	  case tagrange of
	  0: (ptr: ptmemory);
	  1: (int: integer); 2: ()
	 end;

begin (* ordptr *)
  with fudge do
  begin ptr := p;  ordptr := int end
end (* ordptr *);


function filebuf(var 