#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * EM1 - UNIX as translator
 *
 * Debugging routines
 */

#ifdef DUMP
#define	PROMT	'#'

char *typestr[]	EQ {"missing","const","procname","glosym","locsym","pseudo"};
char *labstr[]	EQ {"no","yes"};

char *statstr (status) {
	register char *buf;
	register stat,n;

	n=0;
	stat=status&0377;
	buf=string;
	while(n++<19)
		*buf++ = ' ';
	*buf=0;
	if (stat&DEF) {
		buf = &string[0];
		*buf++ = 'd'; *buf++ = 'e'; *buf++ = 'f';
	}
	if (stat&IMP) {
		buf = &string[4];
		*buf++ = 'i'; *buf++ = 'm'; *buf++ = 'p';
	}
	if (stat&EXP) {
		buf = &string[8];
		*buf++ = 'e'; *buf++ = 'x'; *buf++ = 'p';
	}
	if (stat&OCC) {
		buf = &string[12];
		*buf++ = 'o'; *buf++ = 'c'; *buf++ = 'c';
	}
	if (stat&REL) {
		buf = &string[16];
		*buf++ = 'r'; *buf++ = 'e'; *buf++ = 'l';
	}
	return(string);
}

debug_dump() {
	register glob_t	*gb;
	register proc_t	*pp;
	register locl_t	*lb;
	int i;

	if (dumps==0) return;
	else if (dumps == 1 ) {
		putchar(PROMT);
		flush();
		return;
	     }
	printf("\n** EM1 - UNIX as translator  **\n");
	printf("    %8s%8s%8s\n","labnum","labval","defined");
	for ( lb = loclabel ,i = 1;lb < &loclabel[MAXLOCLABEL] ; lb++,i++)
		if (lb->l_num)
			printf("%4d%8d%8d  %-s\n", i, lb->l_num,
				lb->l_val, labstr[lb->l_status&DEF]);
	printf("\t%8s%8s\n","p_name","status");
	for (pp=procdesc,i=0;pp<=last_proc;pp++,i++)
		printf("%5d\t%8s  %s\n",i,pp->p_name,
			statstr(pp->p_status));
	printf("\t%8s%8s%8s%8s\n","g_name","value","(octal)","status");
	for (gb = globlabel,i = 0;gb < &globlabel[MAXLABEL]; gb++, i++)
		if (gb->g_name[0])
			printf("%5d\t%8s%7d (%6o)  %s\n",i,gb->g_name,0,
				0,statstr(gb->g_status));
	putchar('\n');
	putchar(PROMT);
	flush();
}

char *pseuname(i) {
	register char *s;

	switch(i) {
	case ps_bss: s = "bss"; break;
	case ps_con: s = "con"; break;
	case ps_end: s = "end"; break;
	case ps_eof: s = "eof"; break;
	case ps_mes: s = "mes"; break;
	case ps_exc: s = "exc"; break;
	case ps_exd: s = "exd"; break;
	case ps_ima: s = "ima"; break;
	case ps_imc: s = "imc"; break;
	case ps_hol: s = "hol"; break;
	case ps_let: s = "let"; break;
	case ps_pro: s = "pro"; break;
	case ps_rom: s = "rom"; break;
	case ps_fwp: s = "fwp"; break;
	default:     s = "???";
	}
	return(s);
}

dump_line(i,lnp) int i; line_t *lnp;{
	register line_t *ln;
	register typ,mnem;

	if (dumps==0 || lnp->instr_num==op_nul)
		return;
	ln=lnp;
	printf("%4d  %3.3s%9.9s",i,
		(mnem = ln->instr_num&0377) >= sp_lmnem ?
			pseuname(mnem) :
			mnemon[mnem].m_name,
		typestr[typ = ln->type1]);
	switch (typ) {
	case PROCNAME:
		printf("  %8s",procdesc[ln->ad.ad_i].p_name);
		break;
	case GLOSYM:
		printf("  %8s", ln->ad.ad_gp->g_name);
		break;
	case CONST:
		printf("  %8d", ln->ad.ad_i);
		break;
	case LOCSYM:
		printf("  %8d", ln->ad.ad_lp->l_num);
	}
	putchar('\n');
}


dump(fp) fake_t *fp;{
	register fake_t *p;

	if (dumps==0)
		return;
	p=fp;
	printf("   -%3d ",p-fake);
	switch(p->type){
	case CONS:	printf("CONS   "); break;
	case LOCL:	printf("LOCL   "); break;
	case EXT:	printf("EXT    "); break;
	case REG:	printf("REG    "); break;
	case STK:	printf("STK    "); break;
	case ADDREXT:	printf("ADREXT "); break;
	case ADDRLOCL:	printf("ADRLOC "); break;
	default:	printf("?TYPE? ");
	}
	printf("OFFSET %c %-6o	",
		p->flags&OFF?':':'=',p->offset);
	printf("INDEX : ");
	if(p->type==REG||p->type==STK)
		printf("%5d    ",p->index);
	else if(p->index)
		printf("%-9s",p->index);
	else
		printf("%-9c",'-');
	if (p->flags & INT)
		printf("INTEGER ");
	else
		printf("FLOAT	");
	if (p->flags & IND)
		printf("INDIR	");
	else
		putchar('\t');
	switch (p->flags & CONV){
	case IFC:	printf("INT-FLT"); break;
	case FIC:	printf("FLT-INT"); break;
	case DFC:	printf("DBL-FLT"); break;
	case FDC:	printf("FLT-DBL"); break;
	case 0:		printf("NO CONV"); break;
	default:	printf("?CONV??");
	}
	putchar('\n');
}

dump_fake () {
	register fake_t *p;

	if (dumps==0)
		return;
	p = fsp;
	while(p>fake) {
		putchar('>');
		dump(p--);
	}
	putchar('\n');
	printf("cond.codes : %d ; ",coco-fake);
}

dump_regs() {
	register n;

	if (dumps==0)
		return;
	printf("reg pointers:	iregs:");
	n=0;
	while (n<MAXIREG)
		if (iregs[n++])
			printf(" %d",iregs[n-1]-fake);
		else
			printf(" -");
	printf("; fregs:");
	n=0;
	while (n<MAXFREG)
		if (fregs[n++])
			printf(" %d",fregs[n-1]-fake);
		else
			printf(" -");
	putchar('\n');
}

#endif
