/*
**	validate that log is not being used with any
**	standard input or output redirection - this
**	includes asynchronous use.
**	The test checks that file descriptors 0, 1, and 2 represent
**	the same tty.
*/

#include	<local-system>
#include	<types.h>
#include	<stat.h>

okuse()
{
	struct stat	sbuf[3];
	register i;

	for (i = 0; i < 3; i++)
		if (fstat(i, &sbuf[i]) == SYSERROR ||		/* stat failed ??? */
		    (sbuf[i].st_mode & S_IFMT) != S_IFCHR ||	/* not a tty */
		    i &&
		    (sbuf[i].st_dev != sbuf[i-1].st_dev ||
			sbuf[i].st_ino != sbuf[i-1].st_ino))	/* some sort of redirection */
			return 0;
	return 1;
}
