/*
**	Definitions of things to be used by the network spooling programs
*/

#define	FILESDIR	"~files/"
#define	WORKDIR		"~work/"
#define	UNFDIR		"/NETFILES/"
#define	NETDEV		"/dev/net/"
#define	LOCKFILE	"/.lock"
#define	LOGFILE		"/.log"
#define	TMPFILE		"/.tmp"


/*
**	Structure to define contents of lockfile
*/

enum netstates
{
	net_inactive, net_closed, net_opening, net_idle, net_send, net_recv, net_error, net_down
};

struct lock
{
	long		lk_size;		/* bytes currently queued for transmission */
	long		lk_rcvd;		/* bytes received */
	long		lk_sent;		/* bytes sent */
	long		lk_rate;		/* current transfer rate bytes/sec */
	enum netstates	lk_state;		/* daemon state */
	short		lk_pid;			/* process id of daemon */
	char		lk_file[DIRSIZ];	/* last active file name */
};


/*
**	Structure to define records in files in NETDIR
*/

#define	NETDATASIZE	47

struct netr
{
	char	nr_flag;
	char	nr_data[NETDATASIZE];
};

/*
**	FTP types + record tags
*/

#define	NC_HSTDN	'D'
#define	NC_FILE		'F'
#define	NC_HOST		'H'
#define	NC_MAIL		'M'
#define	NC_NAME		'N'
#define	NC_PRINT	'P'
#define	NC_REMOVE	'R'
#define	NC_STATE	'S'
#define	NC_HSTUP	'U'
#define	NC_UID		'i'
#define	NC_LNAME	'l'
#define	NC_MESSAGE	'm'
#define	NC_SIZE		's'
#define	NC_TTYNAME	't'
#define	NC_UNLINK	'u'
#define	NC_NOGO		'z'


/*
**	Communication signals for daemon
*/

#define	NS_GETGOING	SIGILL	/* start sleeping daemon */
#define	NS_STOP		SIGTRAP	/* stop current network job */
#define	NS_RESTART	SIGIOT	/* restart current network job */
#define	NS_REPEAT	SIGEMT	/* repeat current network job */
#define	NS_RELINQUISH	SIGFPE	/* give up network after current job */
#define	NS_AQUIRE	SIGPIPE	/* aquire network */

/*
**	Miscellany
*/

#define	MAXUNAME	(DIRSIZ-6)		/* max length of username in saved file name */
#define	NULLSTR		(char *)0
#define	STREQUAL	0
