/*
 *	A program to examine the classes a user is in, pick the best possible
 *	limits from them and compose the users total limits from these.
 *	Flag is:
 *		-w	mail user of the change
 *
 *	This program:
 *		checks to see the user is not logged on,
 *		works out if a change is necessary,
 *		moves directories using "mvdir"
 *		awards best possible limits
 *		warns of people who are over supposed maximum limits.
 *
 *	NOTE: The password entry templates are COMPILED IN (quick but nasty)
 *		and so new class templates must be added with care.....
 *
 *	All data comes from the compiled-in templates.
 *
 *	Useful for end-of-session cleanups, and giving people what they
 *	deserve........   tee hee.......
 *
 *	Peter Ivanov,       June 1979.
 *	Improved in numerous ways	Robert Hegedus Jan 81
 */

/*	include all the inclusions......	*/

#include	<local-system>
#include	<types.h>
#include	<passwd.h>
#include	<utmp.h>
#include	<signal.h>
#include	<stdio.h>

/*	global data	*/

#define	PROMPT(x)	if(prompt) printf(x)

#define LOGNAME 100
#define DIREC	100

struct dataar
	{
	char	*da_class;
	struct pwent	da_dpw;
	}
	dataar[CLASSMASKSIZE*BITSINMASK] =
	{
	/* the compiled-in templates */
#		include <classincludes.h>
	};

struct pwent upw;
struct lnode	lnod;
char	logname[LOGNAME];
char	direc[DIREC];
char	buf[SSIZ];
char	tbuf[17];	/* 16 + 1 bit for null termination, to do with terminals*/
char	*origdirec;
char	update;
char	change;
char	prompt, wflag;
char	stopf;
char	*printterm();
char	*strrchr();

main(argc, argv)
int	argc;
char	*argv[];
{
register int	size;
int oldsig;
extern stop();

if (signal(SIGINT,SIG_IGN) == SIG_DFL)
	signal(SIGINT,stop);
if (signal(SIGQUIT,SIG_IGN) == SIG_DFL)
	signal(SIGQUIT,stop);
while (argc-- > 1)
	{
	if(**++argv == '-')
		{
		while(*++*argv)
			switch(**argv)
			{
			case 'w':	wflag++;
					break;
			default:	error("Usage: adjust [-w]");
			}
		}
	else
		{
		error("Usage: adjust [-w]");
		}
	}

	/* args are now set up */
	if( gtty(0, buf) != -1 )
		prompt ++;

	/* prompts set up */
	
	while (!stopf)
	{
	PROMPT("login name: ");
	if(gets(logname))
		{
		upw.pw_strings[LNAME] = logname;
		size = getpwuid(&upw, buf, sizeof buf);
		if (size == sizeof buf)
			{
			error("string buffer too small");
			}
	
		if(size > 0)
			{
			/* there is an entry */

			/* see if the user is logged in, via lnode*/
			lnod.l_uid = upw.pw_uid;
			if(limits(&lnod, L_OTHLIM) < 0)
				{
				/* all ok */
				change = 0;
				update = 0;
				if (adjust())
					{
					oldsig = (int)signal(SIGINT, SIG_IGN);
					if( (change) && (chngpwent(&upw) != 1) )
						error("chngpwent failed");
					else
					    if( (update) && (updtpwent(&upw) != 1) )
						    error("updtpwent failed");
					signal(SIGINT, oldsig);
					if(wflag) mail();
					}
				}
			  else
				{
				/* don't touch, cos he is logged in */
				printf("%s is presently logged in\n",logname);
				}
			}
		  else
			{
			/* there is no entry */
			printf("%s :  no such login name\n",logname);
			}
		}
	  else
		{
		fprintf(stderr,"adjust: end\n");
		exit(0);
		}
	}
	exit(1);
}

error(s1)
char *s1;
{
printf("adjust : %s\n",s1);
exit(1);
}

adjust()
{
struct pwent	tp;

register int	i;
register int	j;

int	firstclass;
register struct pwent	*class;

char	*cp;
char	ch;
char	sprung;

/* Check to see whether he is in a class */

	j = 0;
	for (i=0; (i < CLASSMASKSIZE); i++)
	    if(upw.pw_cmask[i])
		{
		j++;
		break;
		}
	if(j==0)
	    {
	    printf("%s has no  classes\n", logname);
	    return(0);
	    }
	firstclass = -1;
	sprung = 0;

/*
 *	For an updpwent increment update flag, for a chngpwent increment change flag.
 * Initialize the tp structure references to minimum values (NB: 0 is unlimited limit)
 */

	tp.pw_dlimit = 1;
	tp.pw_doverflw = 1;
	tp.pw_plimit = 1;
	tp.pw_tmask = 0;
	tp.pw_tbrate = 1;
	tp.pw_shares = 1;
	tp.pw_pages = 1;
	tp.pw_mplimit = 1;
	tp.pw_mlimit = 1;
	tp.pw_tblim = 1;
	tp.pw_flags = 0;
	tp.pw_xflags = 0;

 /* Set up his current directory path in origdirec */

	origdirec = upw.pw_strings[DIRPATH];
	cp = strrchr(origdirec,'/');
	ch = *++cp;
	*cp = 0;

		for(i=0; i < (CLASSMASKSIZE*BITSINMASK); i++)
	    {
		class = &dataar[i].da_dpw;
		if(class->pw_cmask[i/BITSINMASK] & upw.pw_cmask[i/BITSINMASK])
		{
			if(firstclass == -1)
				firstclass = i;
			tp.pw_dlimit = best(class->pw_dlimit,  tp.pw_dlimit);
			tp.pw_doverflw = best(class->pw_doverflw, tp.pw_doverflw);
			tp.pw_plimit = best(class->pw_plimit, tp.pw_plimit);
			tp.pw_tmask |= class->pw_tmask;
			tp.pw_tbrate = best(class->pw_tbrate, tp.pw_tbrate);
			tp.pw_shares = best(class->pw_shares, tp.pw_shares);
			tp.pw_pages = best(class->pw_pages, tp.pw_pages);
			tp.pw_mplimit = best(class->pw_mplimit, tp.pw_mplimit);
			tp.pw_mlimit = best(class->pw_mlimit, tp.pw_mlimit);
			tp.pw_tblim = best(class->pw_tblim, tp.pw_tblim);
			tp.pw_flags |= class->pw_flags;
			tp.pw_xflags |= class->pw_xflags;
			if ( strcmp(origdirec,class->pw_strings[DIRPATH]) == 0 )
				sprung++;
		}

	    }
	    *cp = ch;

		if(check("dlimit", upw.pw_dlimit, tp.pw_dlimit))
		   upw.pw_dlimit = tp.pw_dlimit;
		if(check("doverflw", upw.pw_doverflw, tp.pw_doverflw))
		   upw.pw_doverflw = tp.pw_doverflw;
		if(check("plimit", upw.pw_plimit, tp.pw_plimit))
		   upw.pw_plimit = tp.pw_plimit;
		if(upw.pw_tmask & ~tp.pw_tmask)
			{
			printf( "%s : terminals are %s ",logname,printterm(upw.pw_tmask) );
			printf( "(should be %s)\n", printterm(tp.pw_tmask) );
			}
		else
		   {
		   upw.pw_tmask |= tp.pw_tmask;
		   update++;
		   }
		if(check("tbrate", upw.pw_tbrate, tp.pw_tbrate))
		   upw.pw_tbrate = tp.pw_tbrate;
		if(check("shares", upw.pw_shares, tp.pw_shares))
		   upw.pw_shares = tp.pw_shares;
		if(check("pages", upw.pw_pages, tp.pw_pages))
		   upw.pw_pages = tp.pw_pages;
		if(check("mplimit", upw.pw_mplimit, tp.pw_mplimit))
		   upw.pw_mplimit = tp.pw_mplimit;
		if(check("mlimit", upw.pw_mlimit, tp.pw_mlimit))
		   upw.pw_mlimit = tp.pw_mlimit;
		if(check("tblim", upw.pw_tblim, tp.pw_tblim))
		   upw.pw_tblim = tp.pw_tblim;
		if (upw.pw_flags & ~tp.pw_flags)
			printf( "%s : flags are 0%o (should be 0%o)\n",
				 logname,upw.pw_flags, tp.pw_flags);	/* print flags routine to come later*/
		else
		   {
		   upw.pw_flags |= tp.pw_flags;
		   update++;
		   };
		if (upw.pw_xflags & ~tp.pw_xflags)
			printf( "%s : xflags are 0%o (should be 0%o)\n",
				 logname,upw.pw_xflags, tp.pw_xflags);	/* print xflags routine to come later*/
		else
		   {
		   upw.pw_xflags |= tp.pw_xflags;
		   update++;
		   }

/* If sprung is set then the move need not take place,
 * however, if sprung is zero then he must be moved into
 * a suitable class directory.
 */

     if (!sprung)
	{
		strcpy(direc, dataar[firstclass].da_dpw.pw_strings[DIRPATH]);
		strcat(direc, logname);
		change++;
		mvit();
		upw.pw_strings[DIRPATH] = direc;
	}

return(1);


/* and thats the lot */
}

stop()
{
signal(SIGINT,SIG_IGN);
stopf++;
}


/* If the "w" flag is set then the user will be notified of the change having taken place*/

mail()
{
int status;

if(fork())
	{
	wait(&status);
	return(0);
	}

close(0);
open("/usr/lib/pwe/adjust.mail", 0);	/* Mail will be written directly later*/
execl("/bin/mail", "adjust.mail", logname, 0);
perror("mail");
exit(1);
}


/* "mvit" uses /etc/bin/mvdir to move the users login directory*/

mvit()
{
	register int cpid;
	register char	*c, *sl;
	int status;

	if(cpid = fork())
	  {
		/* parent */ 
		if(cpid == -1)
			{
			error(" cannot fork mvdir");
			}
	  wait(&status);
	  }
	else
		{
		  execl("/etc/bin/mvdir","mvdir",origdirec,direc,0);
		  perror("mvdir");
		  exit(1);
		}
}


/* "best" calculates the best of the two limits given to this function */

best(classlim, currmax)
unsigned	classlim;
unsigned	currmax;
{
if( ((classlim > currmax) && (currmax !=0))
	|| (classlim == 0) )
	return(classlim);
return(currmax);
}


/* "check" to see whether user has a limit better than he should have,
	and warns of this fact*/

check(s, orig, new)
char	*s;
{
	if( (orig > new) || (orig == 0) && (new != 0) )
		{
		printf("%s : %s is %d (should be %d)\n",
			logname, s, orig, new);
		return(0);
		}
	update++;
	return(1);
}

/* "printterm" returns the string of terminals, given the terminal mask */

char	*printterm(t)
unsigned short	t;
{
	register int	i;
	char	*c;
	c = &tbuf[0];
	for (i = 0; i < ( (sizeof t)*BITSINBYTE ); i++)
	{
		if(t&01)
			{
			*c = 'a' + i;
			c++;
			}
		t >>= 1;
	}
	*c = 0;
	return(tbuf);
}
