h35408
s 00478/00000/00000
d D 1.1 81/03/01 18:32:50 root 1 0
e
u
U
t
T
I 1
#include <local-system>
#include <sys/types.h>
#include <sys/stat.h>
#include <passwd.h>
#include <class.h>
#include <stdio.h>
/*
 * pv - list the perversities of all the users (foul)
 *
 *
 * pv [-wdsougrpaniclxtLPT] [passwdfile] [lowuid [..hiuid]]
 *	w: who --> give first name last name
 *	d: give initial directory path
 *	s: give initial shell
 *	o: give other info
 *	u: gives uid
 *	g: gives gid
 *	r: with the lflag gives a recursive look at the directories
 *	p: gives encrypted password
 *	a: == wdsugp
 *	n: print number of users
 *	i: people without passwords and initial shells
 *	c: classes
 *	l: give a list of all his/hers files (login directory only)
 *	x: people without passwords
 *	t: users terminal groups
 *	L: last time used
 *	P: alternate password file
 *	T: print usage times
 *
 *		Written Bryan David Palmer,
 *		    Inspired by Peter (-wdsourpaniclxtLPT) Ivanov
 *			P.S: don't blame me for it -- BDP fix
 */


struct pwent pe;
char buf[SSIZ];
long	lasttime,
	time();
#define	SECSINHR	(60*60)
struct stat se;

short	wflag,
	sflag,
	dflag,
	oflag,
	pflag,
	uflag,
	gflag,
	xflag,
	tflag,
	iflag,
	lflag,
	nflag,
	rflag,
	Lflag,
	Pflag,
	Tflag,
	Xflag,
	cflag;

char initsh[] = "/usr/logins/initsh";

compar(s1,s2)
register char *s1, *s2;
{
	while((*s1++ == *s2++) && (s1[-1]));
	return(*--s1-*--s2);
}

struct dirbuf
{
	ino_t	dd_inode;
	char	dd_name[14];
}dirbuf;



#define MAXDIRSZ  1000
#define	NAMEPREFIX	':'	/* change this if you don't like it */
char direct[MAXDIRSZ][14];

long tell();
char *ctime();

lscomp(s1,s2)
register char *s1, *s2;
{
	register int len;

	len = 14;
	while((*s1++ == *s2++) && (--len));
	return(*--s1-*--s2);
}

printtimes(conect, cpu)
long conect, cpu;
{
	char wundabuf[8];	/* all is revealed */
	char eveni_wunda[8];	/* see wot i mean */

	printf("Connect time:\t%s\tCpu time: %s\n",
	    ptime(conect, wundabuf),
	    ptime(cpu/60, eveni_wunda));
}

printfiles(directory,indent)
register char *directory;
{
	register int fd;
	register int i, j, shift;
	long place;
	char *tm;

	if((chdir(directory)) == -1)
	{
		printf("%s: cannot chdir\n",directory);
		return(1);
	}
	if((fd = open(".",0)) == -1)
	{
		printf("%s: can't open\n",directory);
		return(0);
	}
	i = 0;
	while((read(fd,&dirbuf,16) == 16) && (i < MAXDIRSZ))
	{
		if(dirbuf.dd_inode)
		{
			for(j = 0; j < 14; j++)
				direct[i][j] = dirbuf.dd_name[j];
			i++;
		}
	}
	qsort(direct,i,14,lscomp);
	for(j = 0; j < i; j++)
	{
		if(stat(direct[j],&se) != -1)
		{
			tm = ctime(&se.st_mtime);
			tm[24] = '\0';
			if((se.st_mode & S_IFREG) == 0)
			{
				if((se.st_mode & S_IFBLK) == S_IFBLK)
					putchar('b');
				else if(se.st_mode & S_IFDIR)
					putchar('d');
				else if(se.st_mode & S_IFCHR)
					putchar('c');
				else if(se.st_mode & S_IFIFO)
					putchar('f');
				else
					putchar('-');
			}
			else
			{
				if(se.st_mode & (S_IFALK & ~S_IFREG))
					putchar('A');
				else if(se.st_mode & (S_IFLOK & ~S_IFREG))
					putchar('L');
				else
					putchar('-');
			}
			for(shift = 0; shift <= 6; shift += 3)
			{
				if(se.st_mode & S_IREAD >> shift)
					putchar('r');
				else
					putchar('-');
				if(se.st_mode & S_IWRITE >> shift)
					putchar('w');
				else
					putchar('-');
				if(((se.st_mode & S_ISUID) && shift == 0)
				 || ((se.st_mode & S_ISGID) && shift == 3))
					putchar('s');
				else if(se.st_mode & S_IEXEC >> shift)
					putchar('x');
				else
					putchar('-');
			}
			if(se.st_mode & S_ISVTX)
				putchar('t');
			else
				putchar(' ');
			printf(" %3d %4d\t%ld\t %s %14s\n",
				se.st_nlink, se.st_uid
				,se.st_size
				,tm,direct[j]);
		}
	}
	if(rflag)
	{
		lseek(fd,32l,0);	/* seek past '.' and '..' */
		while(read(fd,&dirbuf,16) == 16)
		{
			if(dirbuf.dd_inode)
			{
				stat(dirbuf.dd_name,&se);
				if(S_IFDIR & se.st_mode)
				{
					place = tell(fd);
					close(fd);
					printf("./");
					for(i = 0; i < indent; i++)
						putchar('/');
					printf("%s:\n",dirbuf.dd_name);
					if(printfiles(dirbuf.dd_name,indent+1) != 1)
						chdir("..");
					fd = open(".",0);
					lseek(fd,place,0);
				}
			}
		}
	}
	close(fd);
	return(0);
}

printclasses()	/* FLOGGED CODE from 'pp.c' */
{
	register int i,j,k;

	printf("Classes:");
	j = k = 0;
	for(i = 0; i < NCLASS; i++)
	{
		if( pe.pw_limits.l_cmask[classes[i].c_index] & classes[i].c_mask)
		{
			if(j == 0 && k != 0)
				putchar('\t');
			k++;
			printf("%10s ", classes[i].c_name);
			if( ++j == 7)
			{
				j = 0;
				putchar('\n');
			}
		}
	}
	if(k == 0)
		printf("\tNone\n");
	else if(j != 0)
		putchar('\n');
}


printterms(u)	/* more code from pp */
register tmask_t u;
{
	register i;

	printf("Terminals:\t");
	if(u == 0)
		printf("None\n");
	else if(u == (tmask_t)-1)
		printf("Any\n");
	else
	{

		for(i = 0; i < 16; i++)
		{
			if(u&01)
				putchar('a'+i);
			u >>= 1;
		}
		putchar('\n');
	}
}

char *copytildot(s1, s2)
	char *s1, *s2;
{
	while(*s1 != '.' && *s1 != '\0')
		*s2++ = *s1++;
	*s2 = '\0';
	return(s1);
}

printlast(){
	register char *p;
	char *ctime();
	long time();

	if(pe.pw_extime)
	{
		printf("Last used:\t");
		p = ctime(&pe.pw_extime);
		if(pe.pw_extime < time() - 1555200l)
			printf("%12.12s %4.4s\n", p+4, p+20);
		else
			printf("%16.16s\n", p);
	}
	else
		printf("Account has not been used.\n");
}

main(argc,argv)
char **argv;
{
	register uid_t uid, louid, hiuid;
	register char *s;
	register struct pwent *pee;
	int count;
	char	stdbuf[BUFSIZ];

	while(--argc >= 1 && **(++argv) == '-')
	{
		s = *argv;
		while(*++s)
		{
			switch(*s)
			{
		    case '0': case '1': case '2': case '3': case '4':
		    case '5': case '6': case '7': case '8': case '9':
				continue;
		    case 'a' :	wflag++;
				dflag++;
				sflag++;
				uflag++;
				gflag++;
				pflag++;
				break;
		    case 'c' :	cflag++;
				break;
		    case 'd' :	dflag++;
				break;
		    case 'g' :	gflag++;
				break;
		    case 'i' :	iflag++;
				xflag++;
				break;
		    case 'l' :	lflag++;
				break;
		    case 'n' :	nflag++;
				break;
		    case 'o' :	oflag++;
				break;
		    case 'p' :	pflag++;
				break;
		    case 'r' :	rflag++;
				break;
		    case 's' :	sflag++;
				break;
		    case 't' :  tflag++;
				break;
		    case 'u' :	uflag++;
				break;
		    case 'w' :	wflag++;
				break;
		    case 'x' :  xflag++;
				break;
		    case 'L' :	Lflag++;
				break;
		    case 'P' :	Pflag++;
				break;
		    case 'T' :  Tflag++;
				break;
		    case 'X':	Xflag++;
				lasttime = time((long *)0) - atoi(s+1)*SECSINHR;
				break;
		    default :	printf("pv [-wdsourpaniclxtLPT] [optpwfile] [louid[..hiuid]]\n");
				exit(1);
			}
		}
	}
	pee = &pe;
	/* see if a new password file is needed */
	if(Pflag)
	{
		argc--;
		pwfile(*argv++);
	}
	if(getpwlog(pee, buf, sizeof(buf)) == -1)
	{
		printf("cannot allocate string area\n");
		exit(1);
	}

	setbuf(stdout, stdbuf);

	count = 0;
	for(; argc-- > 0; argv++)
	{
		s = *argv;
		louid = 0;
		hiuid = PWTABSIZE;
		if((*s >= '0') && (*s <= '9'))
		{
			louid = atoi(s);
			s = copytildot(s, pee->pw_strings[LNAME]);
		}
		else
		{
			if(*s == NAMEPREFIX)
				s++;
			s = copytildot(s, pee->pw_strings[LNAME]);
			if(getpwuid(pee, buf, sizeof(buf)) == -1)
				continue;
			louid =  pee->pw_limits.l_uid;
		}
		if(*s)
		{
			while(*s == '.')
				s++;
			if((*s >= '0') && (*s <= '9'))
				hiuid = atoi(s);
			else if(*s)
			{
				if(*s == NAMEPREFIX)
					s++;
				copytildot(s, pee->pw_strings[LNAME]);
				if((getpwuid(pee, buf, sizeof buf)) != -1)
					hiuid = pee->pw_limits.l_uid;
			}
		}
		else
			hiuid = louid;
		for(uid = louid; uid <= hiuid; uid++)
		{
			pee->pw_limits.l_uid = uid;
			if((getpwlog(pee,buf,sizeof buf)) != -1)
			{
				if(nflag)
				{
					count++;
					continue;
				}
				if((xflag) && (*pee->pw_pword))
					continue;
				if((Xflag) && (pee->pw_age < lasttime))
					continue;
				if((iflag) && (compar(initsh,pee->pw_strings[SHELLPATH]) == 0))
					continue;
				printf("%s",pee->pw_strings[LNAME]);
				if(uflag)
					printf(":%d",pee->pw_limits.l_uid);
				if(gflag)
					printf(":%d",pee->pw_gid);
				if(pflag)
				{
					printf(":%13.13s",pee->pw_pword ?
					 pee->pw_pword : "             ");
				}
				if(wflag)
					printf(":%s %s",pee->pw_strings[FIRSTNAME]
						,pee->pw_strings[LASTNAME]);
				if(sflag)
					printf(":%s",pee->pw_strings[SHELLPATH]);
				if(dflag)
					printf(":%s",pee->pw_strings[DIRPATH]);
				putchar('\n');
				if(cflag)
					printclasses();
				if(tflag)
					printterms(pee->pw_tmask);
				if(oflag)
					printf("Other:\t\t%s\n",pee->pw_strings[OTHER]);
				if(lflag)
				{
					printf("Files:\n");
					printfiles(pee->pw_strings[DIRPATH],0);
				}
				if(Tflag)
					printtimes(pee->pw_contime, pee->pw_cputime);
				if(Lflag)
					printlast();
				if ( cflag||tflag||oflag||lflag||Tflag||Lflag )
					putchar('\n');
			}
		}
	}
	if(nflag)
		printf("%d\n",count);
	fflush(stdout);
	exit(0);
}
E 1
