/*LINTLIBRARY*/

/*
**	Rewrites the fixed portion of the pwentry whose uid matches "pe->pw_limits.l_uid"
**	The string section is not written and neither are the string pointers.
**	returns 1 for success, 0 for failure and PWERROR for error
*/ 

#include	<pwr.h>


updtpwent(pe)
	register struct pwent *pe;
{
	register struct pwent *rp;
	register i;
	struct pwent p;
	register int ri;
	long t;
	char *strings[PWSLENCNT];

	ri = PWERROR;

	/*	open and lock	*/ 

	if ( pwopen( 1 ) == SYSERROR )
		return ri;

	/*	save strings for later return	*/

	for ( i = 0 ; i < PWSLENCNT ; i++ )
		strings[i] = pe->pw_strings[i];

	do
	{
		/*	get address	*/ 

		rp = &p;
		if(!getutab(pe->pw_limits.l_uid, &t))
			break;
		if(!getentry(rp, &t))
			break;

		/* ok got entry, now fix data which must not alter... */ 

		pe->pw_next = rp->pw_next;
		pe->pw_last = rp->pw_last;
		for(i = 0; i < PWSLENCNT; i++)
			pe->pw_strings[i] = rp->pw_strings[i];

		/* alter entry */ 

		if(!putentry(pe, &t))
			break;

		ri = 1;
	}
	while(0);

	unlock();

	/* and kindly return string pointers */ 

	for(i = 0; i < PWSLENCNT; i++)
		pe->pw_strings[i] = strings[i];

	return(ri);
}
